/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.backward;

import org.simantics.db.WriteGraph;
import org.simantics.objmap.exceptions.MappingException;

/**
 * Contains rules for creating and updating domain elements for given
 * range elements.
 * @author Hannu Niemist&ouml;
 */
public interface IBackwardLinkType<Domain, Range> extends IBackwardMappingRule<Domain, Range> {
    /**
     * Creates a domain element based on a known range element.
     */
    Domain createDomainElement(WriteGraph graph, Range rangeElement) throws MappingException;
}
