/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem.internal;

import org.simantics.nativemem.ProcessMemoryInfo;
import org.simantics.nativemem.internal.Util;

public class CMemoryInfo
implements ProcessMemoryInfo {
    public long currentRSS;
    public long peakRSS;

    public String toString() {
        return "CMemoryInfo [Current RSS=" + this.currentRSS + ", Peak RSS=" + this.peakRSS + "]";
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSS ").append(Util.toMb(this.currentRSS)).append("M / ").append(Util.toMb(this.peakRSS)).append("M");
        return sb.toString();
    }

    @Override
    public String headerRow() {
        return "RSS [MB]\tPeak RSS [MB]";
    }

    @Override
    public String dataRow() {
        return Util.toMb(this.currentRSS) + "\t" + Util.toMb(this.peakRSS);
    }

    public static void main(String[] args) {
        System.out.println(new CMemoryInfo().toHumanReadableString());
        System.out.println(new CMemoryInfo().headerRow());
        System.out.println(new CMemoryInfo().dataRow());
    }
}

