/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem;

/**
 * Architecture-independent representation of a native processes memory usage
 * state.
 * 
 * @author Tuukka Lehtonen
 */
public interface ProcessMemoryInfo {

    /**
     * @return a non-structured human readable string representation of this instances contents
     */
    String toHumanReadableString();

    /**
     * @return tab-separated row of text containing N columns of explanatory
     *         header text for writing a tab-separated "CSV" file
     */
    String headerRow();

    /**
     * @return tab-separated row of text containing N columns of data values
     *         that match the explanations provided by {@link #headerRow()}
     */
    String dataRow();

}