/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.actions;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.operations.Operation;
import org.simantics.modeling.ModelingOperationConstants;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigationTargetChooserDialog;
import org.simantics.modeling.utils.Monitors;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.datastructures.persistent.IContextMap;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class NavigateToTarget
extends Operation {
    private static final Comparator<? super NamedResource> COMPARATOR = new Comparator<NamedResource>(){

        @Override
        public int compare(NamedResource o1, NamedResource o2) {
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.getName(), (Object)o2.getName());
        }
    };

    public NavigateToTarget() {
        super("Navigate to Target");
    }

    public void exec(Session session, IContextMap parameters) {
        final Resource r = (Resource)parameters.get(SUBJECT);
        final IWorkbenchWindow window = (IWorkbenchWindow)parameters.get(ModelingOperationConstants.WORKBENCH_WINDOW);
        final IWorkbenchPart part = (IWorkbenchPart)parameters.get(ModelingOperationConstants.WORKBENCH_PART);
        session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                Resource thisDiagram = NavigateToTarget.getOwnerList(g, r);
                if (thisDiagram == null) {
                    return;
                }
                Set counterparts = FlagUtil.getCounterparts((ReadGraph)g, (Resource)r);
                if (counterparts.size() > 1) {
                    NavigateToTarget.this.asyncQueryTarget(window.getShell(), g, thisDiagram, counterparts, target -> NavigateToTarget.this.navigateToTarget(window, part, thisDiagram, (Resource)target));
                } else if (counterparts.size() == 1) {
                    final String error = NavigateToTarget.this.navigateToTarget(g, window, part, thisDiagram, (Resource)counterparts.iterator().next());
                    if (error != null && !error.isEmpty()) {
                        window.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IStatusLineManager status = WorkbenchUtils.getStatusLine((IWorkbenchPart)part);
                                status.setErrorMessage(error);
                            }
                        });
                    }
                } else {
                    Resource target2 = Monitors.getMonitoredElement(g, r);
                    if (target2 != null) {
                        NavigateToTarget.this.navigateToTarget(g, window, part, thisDiagram, target2);
                    }
                }
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    protected void navigateToTarget(final IWorkbenchWindow window, final IWorkbenchPart sourceEditor, final Resource sourceDiagram, final Resource target) {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                NavigateToTarget.this.navigateToTarget(graph, window, sourceEditor, sourceDiagram, target);
            }
        }, (Procedure)new ProcedureAdapter<Object>(){

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    protected String navigateToTarget(ReadGraph graph, IWorkbenchWindow window, IWorkbenchPart sourceEditor, Resource sourceDiagram, Resource target) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource otherDiagram = NavigateToTarget.getOwnerList(graph, target);
        if (otherDiagram == null) {
            return "";
        }
        if (!sourceDiagram.equals(otherDiagram)) {
            RVI rvi;
            Resource otherComposite = graph.getPossibleObject(otherDiagram, MOD.DiagramToComposite);
            if (otherComposite == null) {
                return "";
            }
            Variable compositeVariable = Variables.getVariable((ReadGraph)graph, (Resource)otherComposite);
            Resource model = Variables.getPossibleModel((ReadGraph)graph, (Variable)compositeVariable);
            RVI rVI = rvi = model == null ? null : compositeVariable.getPossibleRVI(graph);
            if (model == null || rvi == null) {
                return "Navigating via flags only possible under model configuration";
            }
            window.getShell().getDisplay().asyncExec(NavigateToTarget.editorActivator(sourceEditor, otherDiagram, model, rvi, (IEditorPart part) -> {
                ICanvasContext openedCanvas = (ICanvasContext)part.getAdapter(ICanvasContext.class);
                assert (openedCanvas != null);
                openedCanvas.getDefaultHintContext().setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.FALSE);
                ThreadUtils.asyncExec((IThreadWorkQueue)openedCanvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer(openedCanvas, Collections.singleton(target), false));
            }));
        } else {
            ICanvasContext canvas = (ICanvasContext)sourceEditor.getAdapter(ICanvasContext.class);
            assert (canvas != null);
            ThreadUtils.asyncExec((IThreadWorkQueue)canvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer(canvas, Collections.singleton(target), true));
        }
        return null;
    }

    protected void asyncQueryTarget(final Shell parentShell, ReadGraph graph, Resource sourceDiagram, Set<Resource> counterparts, final Consumer<Resource> navigationCallback) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ConnectionUtil cu = new ConnectionUtil(graph);
        final ArrayList<Object> outputs = new ArrayList<Object>(counterparts.size());
        ArrayList<NamedResource> inputs = new ArrayList<NamedResource>(counterparts.size());
        for (Resource counterpart : counterparts) {
            boolean localFlag;
            Variable v;
            Resource composite;
            Resource diagram = NavigateToTarget.getOwnerList(graph, counterpart);
            if (diagram == null || (composite = graph.getPossibleObject(diagram, MOD.DiagramToComposite)) == null || (v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)composite)) == null) continue;
            Object rvi = Variables.getRVI((ReadGraph)graph, (Variable)v);
            rvi = URIStringUtils.unescape((String)rvi);
            Resource connectedComponent = null;
            block5: for (Resource connector : graph.getObjects(counterpart, STR.IsConnectedTo)) {
                Resource diagramConnection = ConnectionUtil.tryGetConnection((ReadGraph)graph, (Resource)connector);
                if (diagramConnection == null) continue;
                Collection connectors = cu.getConnectors(diagramConnection, new HashSet());
                connectors.remove(connector);
                if (connectors.isEmpty() || (connectedComponent = graph.getPossibleObject(diagramConnection, MOD.ElementToComponent)) != null) continue;
                for (Resource conn : connectors) {
                    Resource element = cu.getConnectedComponent(diagramConnection, conn);
                    if (element != null && (connectedComponent = graph.getPossibleObject(element, MOD.ElementToComponent)) != null) continue block5;
                }
            }
            if (connectedComponent != null) {
                rvi = (String)rvi + Variables.Role.CHILD.getIdentifier();
                rvi = (String)rvi + NameUtils.getSafeName((ReadGraph)graph, connectedComponent);
            }
            if (localFlag = sourceDiagram.equals(diagram)) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                rvi = (String)rvi + " (local";
                String label = (String)graph.getPossibleRelatedValue2(counterpart, L0.HasLabel, (Binding)Bindings.STRING);
                if (label != null && !label.isEmpty()) {
                    rvi = (String)rvi + " " + label;
                }
                rvi = (String)rvi + ")";
            }
            FlagClass.Type type = FlagUtil.getFlagType((ReadGraph)graph, (Resource)counterpart, (FlagClass.Type)FlagClass.Type.In);
            switch (type) {
                case In: {
                    inputs.add(new NamedResource((String)rvi, counterpart));
                    break;
                }
                case Out: {
                    outputs.add(new NamedResource((String)rvi, counterpart));
                }
            }
        }
        Collections.sort(outputs, COMPARATOR);
        Collections.sort(inputs, COMPARATOR);
        outputs.addAll(inputs);
        if (outputs.isEmpty()) {
            return;
        }
        parentShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (parentShell.isDisposed()) {
                    return;
                }
                NavigationTargetChooserDialog dialog = new NavigationTargetChooserDialog(parentShell, outputs.toArray(new NamedResource[0]), "Choose Navigation Target", "Select single navigation target from list");
                if (dialog.open() != 0) {
                    return;
                }
                if (dialog.getSelection() != null) {
                    navigationCallback.accept(dialog.getSelection().getResource());
                }
            }
        });
    }

    public static Runnable editorActivator(IWorkbenchPart part, Resource diagram, Resource model, RVI rvi, Consumer<IEditorPart> successCallback) {
        String sourcePartId = part.getSite().getId();
        return NavigateToTarget.editorActivator(sourcePartId, diagram, model, rvi, successCallback);
    }

    public static Runnable editorActivator(String editorPartId, Resource diagram, Resource model, RVI rvi, Consumer<IEditorPart> successCallback) {
        return () -> {
            try {
                IEditorPart newPart = WorkbenchUtils.openEditor((String)editorPartId, (IEditorInput)NavigateToTarget.createEditorInput(editorPartId, diagram, model, rvi));
                newPart.getSite().getPage().activate((IWorkbenchPart)newPart);
                successCallback.accept(newPart);
            }
            catch (PartInitException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        };
    }

    private static IEditorInput createEditorInput(String editorPartId, Resource diagram, Resource model, RVI rvi) {
        if (model != null) {
            return new ResourceEditorInput2(editorPartId, diagram, model, rvi);
        }
        return new ResourceEditorInput(editorPartId, diagram);
    }

    @Deprecated
    public static Runnable editorActivator(String editorPartId, Resource diagram, Resource model, String rvi, Consumer<IEditorPart> successCallback) {
        return () -> {
            try {
                IEditorPart newPart = WorkbenchUtils.openEditor((String)editorPartId, (IEditorInput)new ResourceEditorInput2(editorPartId, diagram, model, rvi));
                newPart.getSite().getPage().activate((IWorkbenchPart)newPart);
                successCallback.accept(newPart);
            }
            catch (PartInitException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        };
    }

    public static Runnable elementSelectorZoomer(final ICanvasContext canvas, final Collection<? extends Object> elementObjects, final boolean keepZoom) {
        return new Runnable(){
            int tries = 0;

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                if (++this.tries > 10) {
                    ErrorLogger.defaultLog((IStatus)new Status(1, "", "NavigateToTarget.elementSelectorZoomer failed to find any of the requested elements " + String.valueOf(elementObjects) + ". Giving up."));
                    return;
                }
                IDiagram diagram = (IDiagram)canvas.getHintStack().getHint(DiagramHints.KEY_DIAGRAM);
                if (diagram == null || !NavigateToTarget.zoomToSelection(canvas, diagram, NavigateToTarget.selectElement(canvas, diagram, elementObjects), keepZoom)) {
                    ThreadUtils.getNonBlockingWorkExecutor().schedule(this, 200L, TimeUnit.MILLISECONDS);
                }
            }
        };
    }

    public static Set<IElement> selectElement(ICanvasContext canvas, IDiagram diagram, Collection<? extends Object> elementObjects) {
        HashSet<IElement> selection = new HashSet<IElement>(elementObjects.size());
        DataElementMap dataMap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        for (Object object : elementObjects) {
            IElement element = dataMap.getElement(diagram, object);
            if (element == null) continue;
            selection.add(element);
        }
        if (!selection.isEmpty()) {
            for (Selection selection2 : canvas.getItemsByClass(Selection.class)) {
                selection2.setSelection(0, selection);
            }
        }
        return selection;
    }

    public static boolean zoomToSelection(final ICanvasContext canvas, IDiagram diagram, Set<IElement> selection, final boolean keepZoom) {
        final TransformUtil util = (TransformUtil)canvas.getSingleItem(TransformUtil.class);
        CanvasBoundsParticipant boundsParticipant = (CanvasBoundsParticipant)canvas.getAtMostOneItemOfClass(CanvasBoundsParticipant.class);
        if (boundsParticipant == null) {
            return false;
        }
        final Rectangle2D controlBounds = boundsParticipant.getControlBounds().getFrame();
        if (controlBounds == null || controlBounds.isEmpty()) {
            return false;
        }
        final Rectangle2D diagramRect = ElementUtils.getSurroundingElementBoundsOnDiagram(selection);
        if (diagramRect == null) {
            return false;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)canvas.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                GeometryUtils.expandRectangle((Rectangle2D)diagramRect, (double)1.0);
                if (keepZoom) {
                    double scaleFactor = org.simantics.g2d.utils.GeometryUtils.getScale((AffineTransform)util.getTransform());
                    double cwh = controlBounds.getWidth() / (scaleFactor * 2.0);
                    double chh = controlBounds.getHeight() / (scaleFactor * 2.0);
                    AffineTransform view = new AffineTransform();
                    view.scale(scaleFactor, scaleFactor);
                    view.translate(-diagramRect.getCenterX() + cwh, -diagramRect.getCenterY() + chh);
                    util.setTransform(view);
                } else {
                    MarginUtils.Margin margin = MarginUtils.marginOf((double)40.0, (double)0.0, (double)0.0);
                    MarginUtils.Margins margins = new MarginUtils.Margins(margin, margin, margin, margin);
                    util.fitArea(controlBounds, diagramRect, margins);
                }
            }
        });
        return true;
    }

    public static Resource getOwnerList(ReadGraph g, Resource listElement) throws DatabaseException {
        return OrderedSetUtils.getSingleOwnerList((ReadGraph)g, (Resource)listElement, (Resource)DiagramResource.getInstance((ReadGraph)g).Composite);
    }
}

