/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.LifeCycleContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.operation.Layer0X;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleProcesses
extends AbstractProjectFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifeCycleProcesses.class);
    Set<LifeCycleContext> contexts = Collections.emptySet();

    public void configure() throws ProjectException {
        try {
            this.contexts = (Set)Simantics.getSession().syncRequest((Read)new Read<Set<LifeCycleContext>>(){

                public Set<LifeCycleContext> perform(ReadGraph graph) throws DatabaseException {
                    HashSet<LifeCycleContext> contexts = new HashSet<LifeCycleContext>();
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    for (Resource indexRoot : Layer0Utils.listIndexRoots((ReadGraph)graph)) {
                        for (Resource lcp : QueryIndexUtils.searchByTypeShallow((ReadGraph)graph, (Resource)indexRoot, (Resource)L0X.LifeCycleProcess)) {
                            try {
                                LOGGER.info("Loading life cycle process " + graph.getURI(lcp));
                                Function1 load = null;
                                Function1 unload = null;
                                Variable process = Variables.getVariable((ReadGraph)graph, (Resource)lcp);
                                Variable loadProperty = process.getPossibleProperty(graph, L0X.LifeCycleProcess_load);
                                if (loadProperty != null) {
                                    try {
                                        load = (Function1)loadProperty.getValue(graph);
                                    }
                                    catch (DatabaseException e) {
                                        LOGGER.error("Error loading load property for life cycle process " + graph.getURI(lcp), (Throwable)e);
                                    }
                                } else {
                                    LOGGER.info("No load property for life cycle process " + graph.getURI(lcp));
                                }
                                Variable unloadProperty = process.getPossibleProperty(graph, L0X.LifeCycleProcess_unload);
                                if (unloadProperty != null) {
                                    try {
                                        unload = (Function1)unloadProperty.getValue(graph);
                                    }
                                    catch (DatabaseException e) {
                                        LOGGER.error("Error loading unload property for life cycle process " + graph.getURI(lcp), (Throwable)e);
                                    }
                                } else {
                                    LOGGER.info("No unload property for life cycle process " + graph.getURI(lcp));
                                }
                                LifeCycleContext lcc = new LifeCycleContext(lcp, load, unload);
                                contexts.add(lcc);
                            }
                            catch (DatabaseException databaseException) {
                                LOGGER.info("Error loading life cycle process " + graph.getURI(lcp));
                            }
                        }
                    }
                    return contexts;
                }
            });
            this.contexts.forEach(LifeCycleContext::load);
        }
        catch (DatabaseException e) {
            throw new ProjectException((Throwable)e);
        }
    }

    public void deconfigure() throws ProjectException {
        this.contexts.forEach(LifeCycleContext::unload);
    }
}

