/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.simantics.common.color.Color;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.datatypes.literal.DecimalFormatFormatter;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityNameModifier;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.request.PossibleVariableModel;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.InvertBasicExpressionVisitor;
import org.simantics.modeling.query.QueryProxyChildVariable;
import org.simantics.modeling.scl.CompileProceduralSCLMonitorRequest;
import org.simantics.modeling.scl.CompileSCLMonitorRequest;
import org.simantics.modeling.scl.CompileSCLQueryRequest;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.scl.CompileStructuralValueRequest;

public class All {
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor monitorValueAccessor = new ValueAccessor(){

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            this.setValue(graph, context, value);
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            String expression = (String)graph.getPossibleRelatedValue(context.getRepresents((ReadGraph)graph), L0.SCLValue_expression, (Binding)Bindings.STRING);
            if (expression == null) {
                return;
            }
            InvertBasicExpressionVisitor.invert(graph, context.getParent((ReadGraph)graph), expression, value);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            try {
                Object value = this.getValue(graph, context);
                Binding srcBinding = Bindings.OBJECT.getContentBinding(value);
                return Bindings.adapt((Object)value, (Binding)srcBinding, (Binding)binding);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        private boolean isProcedural(ReadGraph graph, Variable context) throws DatabaseException {
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            Resource type = context.getParent(graph).getPossibleType(graph);
            return graph.isInstanceOf(type, STR.ProceduralComponentType);
        }

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            if (this.isProcedural(graph, context)) {
                return CompileProceduralSCLMonitorRequest.compileAndEvaluate(graph, context);
            }
            return CompileSCLMonitorRequest.compileAndEvaluate(graph, context);
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return org.simantics.db.layer0.function.All.getDatatypeFromValue((ReadGraph)graph, (Variable)context);
        }
    };
    public static final SimpleDateFormat sdfShort = new SimpleDateFormat("d.M.yyyy");
    public static final SimpleDateFormat sdfLong = new SimpleDateFormat("d.M.yyyy H:mm:ss");
    @SCLValue(type="VariableMap")
    public static VariableMap queryChildMap = new VariableMapImpl(){

        private Variable getProxy(ReadGraph graph, Variable context) throws DatabaseException {
            Variable root = Variables.getRootVariable((ReadGraph)graph);
            return new QueryProxyChildVariable(context, context, root, ">>>");
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            if (">>>".equals(name)) {
                return this.getProxy(graph, context);
            }
            return org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariable(graph, context, name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            if ((map = org.simantics.db.layer0.function.All.standardChildDomainChildren.getVariables(graph, context, map)) == null) {
                map = new THashMap();
            }
            map.put(">>>", this.getProxy(graph, context));
            return map;
        }
    };

    private static String formatted(String text, String color, int size) {
        return "<font style=\"font-size:" + size + ";color:" + color + ";\">" + text + "</font>";
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String issueDocumentHeader(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String label = selection.getLabel(graph);
        String severity = (String)selection.getPropertyValue(graph, "severity", (Binding)Bindings.STRING);
        String result = "== " + label + " ==\r\n" + All.formatted("An issue with severity ", "#000000", 12) + All.formatted(severity, "#5050aa", 15) + "\r\n\r\n<hr/>";
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object sclValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return CompileStructuralValueRequest.compileAndEvaluate((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object queryValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return CompileSCLQueryRequest.compileAndEvaluate(graph, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static Boolean monitorReadOnly(ReadGraph graph, Resource converter, Variable ro) throws DatabaseException {
        Variable context = ro.getParent(graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String expression = (String)graph.getPossibleRelatedValue(context.getRepresents(graph), L0.SCLValue_expression, (Binding)Bindings.STRING);
        if (expression == null) {
            return true;
        }
        return !InvertBasicExpressionVisitor.isInvertible(graph, context.getParent(graph), expression);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> String")
    public static String obtainedString(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (String)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)Bindings.STRING);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> Double")
    public static Double obtainedDouble(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (Double)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)Bindings.DOUBLE);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> Boolean")
    public static Boolean obtainedBoolean(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (Boolean)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)Bindings.BOOLEAN);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> Color")
    public static Color obtainedColor(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (Color)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)RGB.Integer.BINDING);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> Vec2d")
    public static Vec2d obtainedVec2d(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (Vec2d)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)Vec2d.BINDING);
    }

    @SCLValue(type="ReadGraph -> Resource -> RelationContext -> Formatter")
    public static Formatter obtainedFormatter(ReadGraph graph, Resource converter, RelationContext context) throws DatabaseException {
        return (Formatter)Layer0Utils.possibleObtainedValue((ReadGraph)graph, (RelationContext)context, (Binding)DecimalFormatFormatter.BINDING);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String modificationTimeTextShort(ReadGraph graph, Resource r, Variable variable) throws DatabaseException {
        Long millis = (Long)variable.getParent(graph).getValue(graph, (Binding)Bindings.LONG);
        return sdfShort.format(new Date(millis));
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String modificationTimeTextLong(ReadGraph graph, Resource r, Variable variable) throws DatabaseException {
        Long millis = (Long)variable.getParent(graph).getValue(graph, (Binding)Bindings.LONG);
        return sdfLong.format(new Date(millis));
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String variableIdDisplayValue(ReadGraph graph, Resource r, Variable variable) throws DatabaseException {
        Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
        RVI rvi = (RVI)variable.getParent(graph).getPossibleValue(graph, rviBinding);
        if (rvi == null) {
            return "Undefined, invalid subscription item";
        }
        Resource model = (Resource)graph.sync((ReadInterface)new PossibleVariableModel(variable));
        Resource run = model != null ? (Resource)graph.sync((ReadInterface)new PossibleActiveExperiment(model)) : null;
        Variable base = run != null ? Variables.getPossibleVariable((ReadGraph)graph, (Resource)run) : null;
        Variable var = base != null ? rvi.resolvePossible(graph, base) : null;
        String rvistr = base != null ? rvi.toPossibleString(graph, base) : null;
        String result = rvistr != null ? URIStringUtils.unescape((String)rvistr) : "";
        return var != null ? result : result + " (INVALID)";
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object nameInputValidator(ReadGraph graph, Resource r, Variable variable) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource container = variable.getParent(graph).getParent(graph).getParent(graph).getPossibleRepresents(graph);
        if (container == null) {
            return null;
        }
        Resource name = graph.getSingleObject(container, L0.HasName);
        final EntityNameModifier modifier = new EntityNameModifier(graph, container, name);
        return new FunctionImpl1<String, String>(){

            public String apply(String proposition) {
                return modifier.isValid(proposition);
            }
        };
    }
}

