/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Iterator;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.modeling.web.JSONGenerator;
import org.simantics.modeling.web.NodeMapper;

public class RouteGraphSerializer
extends StdSerializer<RouteGraph> {
    private static final long serialVersionUID = -2239328941687246672L;
    private NodeMapper mapper;

    public RouteGraphSerializer() {
        this(null);
    }

    public RouteGraphSerializer(Class<RouteGraph> object) {
        super(object);
    }

    public void setNodeMapper(NodeMapper mapper) {
        this.mapper = mapper;
    }

    public void serialize(RouteGraph rg, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ObjectNode linkNode;
        ObjectNode rgNode = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode linkNodes = rgNode.putArray("links");
        ArrayNode routeLineNodes = rgNode.putArray("routeLines");
        for (RouteLine routeLine : rg.getLines()) {
            ObjectNode routeLineNode = routeLineNodes.addObject();
            routeLineNode.put("isHorizonal", routeLine.isHorizontal());
            routeLineNode.put("position", routeLine.getPosition());
            routeLineNode.put("data", (Long)routeLine.getData());
            for (RoutePoint point : routeLine.getPoints()) {
                RouteLink rl;
                if (!(point instanceof RouteLink) || !(rl = (RouteLink)point).getA().equals(routeLine)) continue;
                linkNode = linkNodes.addObject();
                linkNode.put("n1", RouteGraphSerializer.getRouteNodeId((RouteNode)rl.getA()));
                linkNode.put("n2", RouteGraphSerializer.getRouteNodeId((RouteNode)rl.getB()));
            }
        }
        ArrayNode routeTerminalNodes = rgNode.putArray("routeTerminals");
        for (RouteTerminal routeTerminal : rg.getTerminals()) {
            ObjectNode routeTerminalNode = routeTerminalNodes.addObject();
            routeTerminalNode.put("x", routeTerminal.getX());
            routeTerminalNode.put("y", routeTerminal.getY());
            routeTerminalNode.put("minX", routeTerminal.getMinX());
            routeTerminalNode.put("minY", routeTerminal.getMinY());
            routeTerminalNode.put("maxX", routeTerminal.getMaxX());
            routeTerminalNode.put("maxY", routeTerminal.getMaxY());
            routeTerminalNode.put("allowedDirections", routeTerminal.getAllowedDirections());
            routeTerminalNode.put("data", (Long)routeTerminal.getData());
            routeTerminalNode.put("routeToBounds", routeTerminal.isRouteToBounds());
            routeTerminalNode.set("style", (JsonNode)(routeTerminal.getStyle() != null ? JSONGenerator.toJSON(this.mapper, routeTerminal.getStyle()) : NullNode.getInstance()));
            ArrayNode lineEndLengths = routeTerminalNode.putArray("lineEndLengths");
            int dir = 0;
            while (dir < 4) {
                lineEndLengths.add(routeTerminal.getStyle() != null ? routeTerminal.getStyle().getLineEndLength(dir) : 0.0);
                ++dir;
            }
            RouteLine line = routeTerminal.getLine();
            if (line == null || !rg.getLines().contains(line)) continue;
            linkNode = linkNodes.addObject();
            linkNode.put("n1", RouteGraphSerializer.getRouteNodeId((RouteNode)routeTerminal));
            linkNode.put("n2", RouteGraphSerializer.getRouteNodeId((RouteNode)routeTerminal.getLine()));
        }
        if (rg.getLines().isEmpty() && rg.getTerminals().size() == 2) {
            ObjectNode linkNode2 = linkNodes.addObject();
            Iterator iter = rg.getTerminals().iterator();
            linkNode2.put("n1", RouteGraphSerializer.getRouteNodeId((RouteNode)iter.next()));
            linkNode2.put("n2", RouteGraphSerializer.getRouteNodeId((RouteNode)iter.next()));
        }
        jgen.writeRawValue(this.mapper.writeValueAsString(rgNode));
    }

    public static String getRouteNodeId(RouteNode node) {
        if (node.getData() != null) {
            return node.getData().toString();
        }
        if (node instanceof RouteLine) {
            RouteLine rl = (RouteLine)node;
            if (rl.getData() != null) {
                return rl.getData().toString();
            }
            if (rl.getTerminal() != null) {
                String id = rl.getTerminal().getData().toString();
                int count = 0;
                RouteLine next = rl.getNextTransient();
                while (next != null) {
                    ++count;
                    next = next.getNextTransient();
                }
                return id + "_" + count;
            }
            return "_transient_";
        }
        return null;
    }

    public static String getRoutePointId(RoutePoint node) {
        if (node instanceof RouteTerminal) {
            RouteTerminal t = (RouteTerminal)node;
            return t.getData().toString();
        }
        if (node instanceof RouteLink) {
            RouteLink rl = (RouteLink)node;
            return RouteGraphSerializer.getRouteNodeId((RouteNode)rl.getA()) + "_" + RouteGraphSerializer.getRouteNodeId((RouteNode)rl.getB());
        }
        return null;
    }
}

