/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.simantics.g2d.diagram.participant.ElementTransferableProvider;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * Rather dirty way of including element hints with the JSON.
 * 
 * ElementTransferableProvider contains Element reference, thus the name.
 * 
 * @author luukkainen
 *
 */
@JacksonStdImpl
@SuppressWarnings("serial")
public class ElementTransferableSerializer extends StdSerializer<Object> {

	public final static ElementTransferableSerializer instance = new ElementTransferableSerializer();

	private ElementTransferableSerializer() {
		super(Object.class);
	}

	@Override
	public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
		if (value instanceof ElementTransferableProvider) {
			Transferable t = ((ElementTransferableProvider) value).create();
			try {
				if (t != null) {
					DataFlavor flavor = DataFlavor.getTextPlainUnicodeFlavor();
					Object o = t.getTransferData(flavor);
					if (o != null) {
						ByteArrayInputStream is = (ByteArrayInputStream) o;

						byte[] data = new byte[is.available()];
						int read = 0;
						while (is.available() > 0)
							read += is.read(data, read, data.length - read);
						is.close();
						String s = new String(data, flavor.getParameter("charset"));
						s = s.replaceAll("\n", "");
						gen.writeRawValue(s);
						return;
					}
				}
			} catch (UnsupportedFlavorException e) {

			}
		}
		gen.writeNull();
	}

}
