/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web.serializer;

import java.awt.BasicStroke;
import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

/**
 * @author Antti Villberg
 * @since 1.58.0
 */
public class BasicStrokeSerializer extends StdSerializer<BasicStroke> {

	private static final long serialVersionUID = 8516702877563833518L;

	public BasicStrokeSerializer() {
		this(null);
	}

	public BasicStrokeSerializer(Class<BasicStroke> t) {
		super(t);
	}
	
	@Override
	public void serializeWithType(BasicStroke value, JsonGenerator gen, SerializerProvider serializers,
			TypeSerializer typeSer) throws IOException {
		typeSer.writeTypePrefixForObject(value, gen);
		serialize(value, gen, serializers);
		typeSer.writeTypeSuffixForObject(value, gen);
	}

	@Override
	public void serialize(BasicStroke value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
		jgen.writeNumberField("width", value.getLineWidth());
		float[] da = value.getDashArray();
		if(da != null) {
			jgen.writeArrayFieldStart("dash");
			for(int i=0;i<da.length;i++)
				jgen.writeNumber(da[i]);
			jgen.writeEndArray();
		}
	}
	
}