/*******************************************************************************
 *  Copyright (c) 2023 Association for Decentralized Information Management
 *  in Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.web;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.eclipse.swt.widgets.Display;
import org.simantics.db.Resource;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.RouteTerminalPosition;
import org.simantics.diagram.elements.ITextContentFilter;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.modeling.web.serializer.BasicStrokeSerializer;
import org.simantics.modeling.web.serializer.ColorSerializer;
import org.simantics.modeling.web.serializer.ElementTransferableSerializer;
import org.simantics.modeling.web.serializer.INodeSerializer;
import org.simantics.modeling.web.serializer.RectangleSerializer;
import org.simantics.modeling.web.serializer.RouteGraphSerializer;
import org.simantics.modeling.web.serializer.ShapeSerializer;
import org.simantics.modeling.web.serializer.TransformSerializer;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.TransferableProvider;
import org.simantics.scl.runtime.function.Function1;

import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;

/**
 * @author Jussi Koskela
 * @since 1.57.0
 */
public class NodeMapper extends ObjectMapper {

	private static final long serialVersionUID = -7755555279336383006L;

	public NodeMapper() {
		disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
		setVisibility(PropertyAccessor.ALL, Visibility.NONE);
		setVisibility(PropertyAccessor.FIELD, Visibility.ANY);

		SimpleModule module = new SimpleModule();
		module.addSerializer(INode.class, new INodeSerializer());
		module.addSerializer(Color.class, new ColorSerializer());
		RouteGraphSerializer rgs = new RouteGraphSerializer();
		rgs.setNodeMapper(this);
		module.addSerializer(RouteGraph.class, rgs);
		module.addSerializer(Shape.class, new ShapeSerializer());
		module.addSerializer(Rectangle2D.class, new RectangleSerializer());
		module.addSerializer(AffineTransform.class, new TransformSerializer());
		module.addSerializer(BasicStroke.class, new BasicStrokeSerializer());

		//module.addSerializer(TransferableProvider.class, NullSerializer.instance);
		module.addSerializer(TransferableProvider.class,  ElementTransferableSerializer.instance);
		module.addSerializer(RouteTerminalPosition.class, NullSerializer.instance); // TODO: Implement custom serializer
		module.addSerializer(RouteLink.class, NullSerializer.instance);
		module.addSerializer(RouteLine.class, NullSerializer.instance);
		module.addSerializer(RouteTerminal.class, NullSerializer.instance);

		module.addSerializer(Resource.class, NullSerializer.instance);
		module.addSerializer(DataElementMap.class, NullSerializer.instance);

		module.addSerializer(ITextContentFilter.class, NullSerializer.instance);
		module.addSerializer(ITextListener.class, NullSerializer.instance);
		module.addSerializer(Function1.class, NullSerializer.instance);
		module.addSerializer(Display.class, NullSerializer.instance);

		registerModule(module);

		configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
		enableDefaultTyping();
	}

}
