/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ContextInputCallbackViewpointContributor;
import org.simantics.browsing.ui.graph.tester.GraphTesters;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.modelBrowser2.contributions.RelationViewContributor;
import org.simantics.modeling.ui.modelBrowser2.model.RelationViewNode;
import org.simantics.operation.Layer0X;

public class RelationView
extends ContextInputCallbackViewpointContributor {
    public RelationView() {
        super(RelationViewNode.class);
    }

    public Tester getNodeContextTester() {
        return GraphTesters.type((String)"http://www.simantics.org/Layer0X-1.1/RelationView");
    }

    public String getViewpointId() {
        return "Standard";
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void getContribution(ReadGraph graph, NodeContext context, final Consumer<Collection<?>> callback) throws DatabaseException {
        final Session session = graph.getSession();
        RelationViewNode model = (RelationViewNode)((Object)context.getConstant(BuiltinKeys.INPUT));
        final Resource view = model.resource;
        final String filter = (String)context.getConstant(BuiltinKeys.FILTER);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        final Resource input = graph.getPossibleObject(view, l0.PartOf);
        final Resource relation = graph.getPossibleObject(view, L0X.AppliesRelation);
        final String bindingPattern = (String)graph.getPossibleRelatedValue(view, L0X.HasBindingPattern, (Binding)Bindings.STRING);
        GenericRelationIndex index = (GenericRelationIndex)graph.syncRequest((Read)new Adapter(relation, GenericRelationIndex.class));
        index.addListener((RequestProcessor)session, input, new Runnable(){

            @Override
            public void run() {
                Simantics.async((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.accept(RelationView.this.compute((RequestProcessor)session, filter, bindingPattern, view, relation, input));
                        }
                        catch (DatabaseException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        callback.accept(this.compute((RequestProcessor)graph, filter, bindingPattern, view, relation, input));
    }

    Collection<?> compute(RequestProcessor processor, String filter, String bindingPattern, final Resource view, Resource relation, Resource input) throws DatabaseException {
        if (filter == null) {
            filter = "";
        }
        GenericRelationIndex index = (GenericRelationIndex)processor.syncRequest((Read)new Adapter(relation, GenericRelationIndex.class));
        final List results = index.query(processor, filter, bindingPattern, new Object[]{input}, 1000);
        return (Collection)processor.syncRequest(new Read<Collection<?>>(){

            public Collection<?> perform(ReadGraph graph) throws DatabaseException {
                RelationViewContributor contrib = (RelationViewContributor)graph.syncRequest(Queries.adapt((Resource)view, RelationViewContributor.class));
                return contrib.getContribution(graph, results);
            }
        });
    }
}

