/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.tools;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramViewer;
import org.simantics.modeling.ui.diagramEditor.tools.DiagramTools;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class AlignTools
implements DiagramTools {
    private Resource[] selection = new Resource[0];
    Button alignLeft;
    Button alignVertButton;
    Button alignRight;
    Button alignTop;
    Button alignHorizButton;
    Button alignBottom;
    Button distLeft;
    Button distVert;
    Button distRight;
    Button distVertBetween;
    Button distTop;
    Button distHoriz;
    Button distBottom;
    Button distHorizBetween;
    Button rotateCW;
    Button rotateCCW;
    Button flipX;
    Button flipY;

    @Override
    public String getName() {
        return "Align";
    }

    @Override
    public void createContols(Composite parent, FormToolkit toolkit, LocalResourceManager resourceManager) {
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 0).spacing(1, 1).create());
        Composite alignComposite = new Composite(parent, 0);
        Composite distributeComposite = new Composite(parent, 0);
        Composite rotateComposite = new Composite(parent, 0);
        alignComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 2).spacing(0, 0).create());
        distributeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).equalWidth(true).margins(0, 2).spacing(0, 0).create());
        rotateComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).margins(0, 2).spacing(0, 0).create());
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)alignComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)distributeComposite);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)rotateComposite);
        this.alignLeft = toolkit.createButton(alignComposite, "", 8);
        this.alignLeft.setToolTipText("Align Left Edges");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignLeft);
        this.alignVertButton = toolkit.createButton(alignComposite, "", 8);
        this.alignVertButton.setToolTipText("Center on Vertical Axis");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignVertButton);
        this.alignRight = toolkit.createButton(alignComposite, "", 8);
        this.alignRight.setToolTipText("Align Right Edges");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignRight);
        this.alignTop = toolkit.createButton(alignComposite, "", 8);
        this.alignTop.setToolTipText("Align Top Edges");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignTop);
        this.alignHorizButton = toolkit.createButton(alignComposite, "", 8);
        this.alignHorizButton.setToolTipText("Center on Horizontal Axis");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignHorizButton);
        this.alignBottom = toolkit.createButton(alignComposite, "", 8);
        this.alignBottom.setToolTipText("Align Bottom Edges");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.alignBottom);
        this.distLeft = toolkit.createButton(distributeComposite, "", 8);
        this.distLeft.setToolTipText("Distribute Left Edges Equidistantly");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distLeft);
        this.distVert = toolkit.createButton(distributeComposite, "", 8);
        this.distVert.setToolTipText("Distribute Centers Equidistantly Horizontally");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distVert);
        this.distRight = toolkit.createButton(distributeComposite, "", 8);
        this.distRight.setToolTipText("Distribute Right Edges Equidistantly");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distRight);
        this.distVertBetween = toolkit.createButton(distributeComposite, "", 8);
        this.distVertBetween.setToolTipText("Make Horizontal Gaps Between Objects Equal");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distVertBetween);
        this.distTop = toolkit.createButton(distributeComposite, "", 8);
        this.distTop.setToolTipText("Distribute Top Edges Equidistantly");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distTop);
        this.distHoriz = toolkit.createButton(distributeComposite, "", 8);
        this.distHoriz.setToolTipText("Distribute Centers Equidistantly Vertically");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distHoriz);
        this.distBottom = toolkit.createButton(distributeComposite, "", 8);
        this.distBottom.setToolTipText("Distribute Bottom Edges Equidistantly");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distBottom);
        this.distHorizBetween = toolkit.createButton(distributeComposite, "", 8);
        this.distHorizBetween.setToolTipText("Make Vertical Gaps Between Objects Equal");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.distHorizBetween);
        this.rotateCCW = toolkit.createButton(rotateComposite, "", 8);
        this.rotateCCW.setToolTipText("Rotate Counterclockwise");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.rotateCCW);
        this.rotateCW = toolkit.createButton(rotateComposite, "", 8);
        this.rotateCW.setToolTipText("Rotate Clockwise");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.rotateCW);
        this.flipX = toolkit.createButton(rotateComposite, "", 8);
        this.flipX.setToolTipText("Flip About Horizontal Axis");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.flipX);
        this.flipY = toolkit.createButton(rotateComposite, "", 8);
        this.flipY.setToolTipText("Flip About Vertical Axis");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.flipY);
        this.alignVertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.VERT);
            }
        });
        this.alignHorizButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.HORIZ);
            }
        });
        this.alignLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.LEFT);
            }
        });
        this.alignRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.RIGHT);
            }
        });
        this.alignTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.TOP);
            }
        });
        this.alignBottom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.align((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.BOTTOM);
            }
        });
        this.distLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.LEFT);
            }
        });
        this.distVert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.VERT);
            }
        });
        this.distRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.RIGHT);
            }
        });
        this.distVertBetween.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.VERT_BTW);
            }
        });
        this.distTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.TOP);
            }
        });
        this.distHoriz.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.HORIZ);
            }
        });
        this.distBottom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.BOTTOM);
            }
        });
        this.distHorizBetween.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.dist((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (ElementTransforms.SIDE)ElementTransforms.SIDE.HORIZ_BTW);
            }
        });
        this.rotateCW.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.rotate((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (boolean)true);
            }
        });
        this.rotateCCW.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.rotate((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (boolean)false);
            }
        });
        this.flipX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.flip((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (boolean)true);
            }
        });
        this.flipY.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTransforms.flip((IDiagram)AlignTools.getDiagram(), (Resource[])AlignTools.this.getSelected(), (boolean)false);
            }
        });
        this.alignLeft.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_left.png"))));
        this.alignVertButton.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_center.png"))));
        this.alignRight.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_right.png"))));
        this.alignTop.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_top.png"))));
        this.alignHorizButton.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_middle.png"))));
        this.alignBottom.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/align_bottom.png"))));
        this.distLeft.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_left.png"))));
        this.distVert.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_center.png"))));
        this.distRight.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_right.png"))));
        this.distVertBetween.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_horiz.png"))));
        this.distTop.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_top.png"))));
        this.distHoriz.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_middle.png"))));
        this.distBottom.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_bottom.png"))));
        this.distHorizBetween.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/dist_vert.png"))));
        this.rotateCCW.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/rotate_left.png"))));
        this.rotateCW.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/rotate_right.png"))));
        this.flipX.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/flip_x.png"))));
        this.flipY.setImage(resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/flip_y.png"))));
        this.updateUI();
    }

    private static IDiagram getDiagram() {
        IEditorPart ap = WorkbenchUtils.getActiveEditor();
        if (ap instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)ap;
            DiagramViewer viewer = editor.getViewer();
            return viewer.getAdapter(IDiagram.class);
        }
        return null;
    }

    @Override
    public void setSelection(ISelection s) {
        this.selection = ResourceAdaptionUtils.toResources((Object)s);
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                    ArrayList<Resource> sel = new ArrayList<Resource>();
                    Resource[] resourceArray = AlignTools.this.selection;
                    int n = AlignTools.this.selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource r = resourceArray[n2];
                        if (graph.isInstanceOf(r, dr.Element) && !graph.isInstanceOf(r, dr.Connection)) {
                            sel.add(r);
                        }
                        ++n2;
                    }
                    AlignTools.this.selection = sel.toArray(new Resource[sel.size()]);
                }
            });
            this.updateUI();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private void updateUI() {
        boolean showAlign = this.selection.length >= 2;
        boolean showDist = this.selection.length >= 3;
        boolean showRotate = this.selection.length >= 1;
        this.alignBottom.setEnabled(showAlign);
        this.alignHorizButton.setEnabled(showAlign);
        this.alignLeft.setEnabled(showAlign);
        this.alignRight.setEnabled(showAlign);
        this.alignTop.setEnabled(showAlign);
        this.alignVertButton.setEnabled(showAlign);
        this.distBottom.setEnabled(showDist);
        this.distHoriz.setEnabled(showDist);
        this.distHorizBetween.setEnabled(showDist);
        this.distLeft.setEnabled(showDist);
        this.distRight.setEnabled(showDist);
        this.distTop.setEnabled(showDist);
        this.distVert.setEnabled(showDist);
        this.distVertBetween.setEnabled(showDist);
        this.rotateCCW.setEnabled(showRotate);
        this.rotateCW.setEnabled(showRotate);
        this.flipX.setEnabled(showRotate);
        this.flipY.setEnabled(showRotate);
    }

    @Override
    public void dispose() {
    }

    private Resource[] getSelected() {
        return this.selection;
    }
}

