/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.dnd;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.modeling.ui.Activator;

class MarkupDialog
extends Dialog {
    private String title;
    private String topText;
    private String message;
    private int dialogIconType;
    private int viewerStyle;
    private MarkupViewer viewer;
    private IDialogSettings dialogBoundsSettings;

    protected MarkupDialog(Shell parentShell, String dialogId, String title, String topText, String message, int dialogIconType, int viewerStyle) {
        super(parentShell);
        this.title = title;
        this.topText = topText;
        this.message = message;
        this.dialogIconType = dialogIconType;
        this.viewerStyle = viewerStyle;
        this.setShellStyle(this.getShellStyle() | 0x10);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.dialogBoundsSettings = settings.getSection(dialogId);
        if (this.dialogBoundsSettings == null) {
            this.dialogBoundsSettings = settings.addNewSection(dialogId);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBoundsSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(newShell.getDisplay().getSystemImage(this.dialogIconType));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Text text = new Text(composite, 74);
        text.setEditable(false);
        text.setText(this.topText);
        GridDataFactory.fillDefaults().grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)text);
        this.viewer = new MarkupViewer(composite, null, this.viewerStyle);
        this.viewer.setMarkupLanguage((MarkupLanguage)new MarkdownLanguage());
        this.viewer.setEditable(false);
        MarkupViewerConfiguration configuration = new MarkupViewerConfiguration(this.viewer, Activator.getDefault().getPreferenceStore());
        this.viewer.configure((SourceViewerConfiguration)configuration);
        this.viewer.setDocument((IDocument)new Document(this.message));
        GridDataFactory.fillDefaults().grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo(this.viewer.getControl());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, IDialogConstants.PROCEED_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (10 == buttonId) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    public static int open(Shell parent, String dialogId, String title, String topText, String message, int dialogIconType, int dialogStyle, int sourceViewerStyle) {
        MarkupDialog dialog = new MarkupDialog(parent, dialogId, title, topText, message, dialogIconType, sourceViewerStyle);
        dialog.setShellStyle(dialog.getShellStyle() | (dialogStyle &= 0x10000000));
        return dialog.open();
    }
}

