/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagram.style;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.DecorationSVGNode;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.document.DocumentResource;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagram.style.DocumentResult;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;

public class DocumentDecorationStyle
extends StyleBase<DocumentResult> {
    private static final String DECORATION_NODE_NAME = "documentDecorations";

    private Set<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        HashSet<Resource> result = new HashSet<Resource>();
        result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection)) != null) {
            result.add(config);
        }
        return result;
    }

    public DocumentResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
        for (Resource r : this.getContexts(graph, element)) {
            if (!graph.hasStatement(r, DOC.HasDocumentation)) continue;
            AffineTransform transform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
            return new DocumentResult(transform);
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, DocumentResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
            return;
        }
        SVGNode svgNode = (SVGNode)ProfileVariables.claimChild((INode)node, (String)"", (String)DECORATION_NODE_NAME, DecorationSVGNode.class, (Observer)observer);
        Rectangle2D bounds = NodeUtil.getLocalBounds((INode)node, Decoration.class);
        double tx = bounds.getX();
        double ty = bounds.getY();
        double h = bounds.getHeight();
        svgNode.setZIndex(Integer.MAX_VALUE);
        svgNode.setTransform(AffineTransform.getTranslateInstance(tx, ty + h));
        svgNode.setData(Activator.DOCUMENT_SVG_TEXT);
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
    }

    public String toString() {
        return "Document decoration";
    }
}

