/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.units.internal.library.UnitLibrary;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.modeling.ui.componentTypeEditor.StringWriter;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function4;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;

public class ComponentTypeViewerData {
    public static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("([a-z]|_[0-9a-zA-Z_])[0-9a-zA-Z_]*");
    public static final String[] PROPERTY_TYPE_SUGGESTIONS = new String[]{"Double", "Integer", "Float", "String", "Boolean", "Long", "[Double]", "[Integer]", "[Float]", "[String]", "[Boolean]", "[Long]", "Vector Double", "Vector Integer", "Vector Float", "Vector String", "Vector Boolean", "Vector Long"};
    public Resource componentType;
    public FormToolkit tk;
    public Form form;
    public UnitLibrary unitLibrary = UnitLibrary.createDefault();
    public boolean readOnly;
    public NamedResource[] connectionPoints;
    public ComponentTypeViewerPropertyInfo[] properties;

    public ComponentTypeViewerData(FormToolkit tk, Resource componentType, Form form) {
        this.tk = tk;
        this.componentType = componentType;
        this.form = form;
    }

    public void editName(Table table, TableEditor editor, ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, Pattern namePattern) {
        this.editName(table, editor, propertyInfo, selectedItem, column, namePattern, null);
    }

    public void editName(Table table, TableEditor editor, ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, Pattern namePattern, DbConsumer<WriteGraph> extraWriter) {
        this.editName(table, editor, propertyInfo, selectedItem, column, null, (Function2<ComponentTypeViewerPropertyInfo, String, String>)((Function2)(pInfo, name) -> this.validatePropertyName((ComponentTypeViewerPropertyInfo)pInfo, (String)name, namePattern)), extraWriter);
    }

    public void editName(Table table, TableEditor editor, ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, Function2<ComponentTypeViewerPropertyInfo, String, String> nameFilter, Pattern namePattern, DbConsumer<WriteGraph> extraWriter) {
        this.editName(table, editor, propertyInfo, selectedItem, column, nameFilter, (Function2<ComponentTypeViewerPropertyInfo, String, String>)((Function2)(pInfo, name) -> this.validatePropertyName((ComponentTypeViewerPropertyInfo)pInfo, (String)name, namePattern)), extraWriter);
    }

    public void editName(Table table, TableEditor editor, ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, Function2<ComponentTypeViewerPropertyInfo, String, String> nameValidator) {
        this.editName(table, editor, propertyInfo, selectedItem, column, nameValidator, null);
    }

    public void editName(Table table, TableEditor editor, ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, Function2<ComponentTypeViewerPropertyInfo, String, String> nameValidator, DbConsumer<WriteGraph> extraWriter) {
        this.editName(table, editor, propertyInfo, selectedItem, column, null, nameValidator, extraWriter);
    }

    public void editName(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, final Function2<ComponentTypeViewerPropertyInfo, String, String> nameFilter, final Function2<ComponentTypeViewerPropertyInfo, String, String> nameValidator, final DbConsumer<WriteGraph> extraWriter) {
        int extraStyle = propertyInfo.immutable ? 8 : 0;
        final Text text = new Text((Composite)table, extraStyle);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 12) {
                    ComponentTypeViewerData.this.form.setMessage(null);
                    return;
                }
                if (e.type == 25) {
                    e.text = nameFilter != null ? (String)nameFilter.apply((Object)propertyInfo, (Object)e.text) : e.text;
                    return;
                }
                if (e.type == 24) {
                    String error = (String)nameValidator.apply((Object)propertyInfo, (Object)text.getText());
                    if (error != null) {
                        text.setBackground(text.getDisplay().getSystemColor(3));
                        ComponentTypeViewerData.this.form.setMessage(error, 3);
                    } else {
                        text.setBackground(null);
                        ComponentTypeViewerData.this.form.setMessage(null);
                    }
                    return;
                }
                if (e.type == 31) {
                    if (e.detail == 2) {
                        text.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                    e.doit = false;
                }
                final String newValue = text.getText();
                text.dispose();
                String error = (String)nameValidator.apply((Object)propertyInfo, (Object)newValue);
                if (error != null) {
                    return;
                }
                if (propertyInfo.immutable) {
                    return;
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        String prevName = (String)graph.getPossibleRelatedValue2(propertyInfo.resource, L0.HasName);
                        String oldCamelCasedLabel = prevName != null ? ComponentTypeCommands.camelCaseNameToLabel((String)prevName) : "";
                        String oldLabel = (String)graph.getPossibleRelatedValue(propertyInfo.resource, L0.HasLabel);
                        boolean setLabel = oldLabel == null || oldLabel.isEmpty() || oldCamelCasedLabel.isEmpty() || oldCamelCasedLabel.equals(oldLabel);
                        ComponentTypeCommands.rename((WriteGraph)graph, (Resource)propertyInfo.resource, (String)newValue);
                        if (setLabel) {
                            ComponentTypeCommands.setLabel((WriteGraph)graph, (Resource)propertyInfo.resource, (String)ComponentTypeCommands.camelCaseNameToLabel((String)newValue));
                        }
                        if (extraWriter != null) {
                            extraWriter.accept((Object)graph);
                        }
                    }
                });
            }
        };
        if (nameFilter != null) {
            text.addListener(25, listener);
        }
        text.addListener(24, listener);
        text.addListener(27, listener);
        text.addListener(31, listener);
        text.addListener(12, listener);
        text.setText(selectedItem.getText(column));
        text.selectAll();
        text.setFocus();
        editor.setEditor((Control)text, selectedItem, column);
    }

    public void editType(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, final String range, final boolean convertDefaultValue) {
        int extraStyle = propertyInfo.immutable ? 8 : 0;
        final Combo combo = new Combo((Composite)table, extraStyle);
        combo.setText(selectedItem.getText(column));
        String[] stringArray = PROPERTY_TYPE_SUGGESTIONS;
        int n = PROPERTY_TYPE_SUGGESTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String suggestion = stringArray[n2];
            combo.add(suggestion);
            ++n2;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    if (e.detail == 2) {
                        combo.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = combo.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                combo.dispose();
                if (propertyInfo.immutable) {
                    return;
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        String newValue2 = newValue;
                        Resource possibleGraphType = null;
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                        Resource previousRange = graph.getPossibleObject(propertyInfo.resource, L0.HasRange);
                        if (previousRange != null && graph.isInheritedFrom(previousRange, MOD.MonitorValue)) {
                            possibleGraphType = previousRange;
                        } else {
                            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot((this).ComponentTypeViewerData.this.componentType));
                            Resource L0Res = graph.getResource("http://www.simantics.org/Layer0-1.1");
                            List graphTypes1 = QueryIndexUtils.searchByTypeAndName((ReadGraph)graph, (Resource)L0Res, (Resource)L0.ValueType, (String)newValue);
                            List graphTypes2 = QueryIndexUtils.searchByTypeAndName((ReadGraph)graph, (Resource)root, (Resource)L0.ValueType, (String)newValue);
                            HashSet graphTypes = new HashSet(graphTypes1);
                            graphTypes.addAll(graphTypes2);
                            HashSet<Pair> candidates = new HashSet<Pair>();
                            for (Resource graphType : graphTypes) {
                                String hasValueType;
                                Collection stms = graph.getAssertedStatements(graphType, L0.HasValueType);
                                if (stms.size() != 1 || !(hasValueType = (String)graph.getValue(((Statement)stms.iterator().next()).getObject(), (Binding)Bindings.STRING)).equals(newValue)) continue;
                                candidates.add(new Pair((Object)graphType, (Object)hasValueType));
                            }
                            if (candidates.size() == 1) {
                                Pair result = (Pair)candidates.iterator().next();
                                possibleGraphType = (Resource)result.first;
                                newValue2 = (String)result.second;
                            }
                        }
                        ComponentTypeCommands.editType((WriteGraph)graph, (Resource)(this).ComponentTypeViewerData.this.componentType, (Resource)propertyInfo.resource, (boolean)convertDefaultValue, (String)newValue2, (Resource)possibleGraphType);
                        if (range != null) {
                            ComponentTypeCommands.setRange((WriteGraph)graph, (Resource)(this).ComponentTypeViewerData.this.componentType, (Resource)propertyInfo.resource, (String)range);
                        }
                    }
                });
            }
        };
        combo.setFocus();
        editor.setEditor((Control)combo, selectedItem, column);
        combo.addListener(16, listener);
        combo.addListener(31, listener);
    }

    public void editUnit(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column) {
        if (propertyInfo.numberType == null && propertyInfo.sectionSpecificData == null) {
            return;
        }
        int extraStyle = propertyInfo.immutable ? 8 : 0;
        final Combo combo = new Combo((Composite)table, extraStyle);
        String initialValue = selectedItem.getText(column);
        ArrayList units = new ArrayList(this.unitLibrary.getUnits());
        Collections.sort(units, String.CASE_INSENSITIVE_ORDER);
        int i = -1;
        int selected = -1;
        for (String unit : units) {
            combo.add(unit);
            if (!unit.equals(initialValue)) continue;
            combo.select(i);
        }
        if (selected == -1) {
            combo.setText(initialValue);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 31) {
                    if (e.detail == 2) {
                        combo.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = combo.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                combo.dispose();
                if (propertyInfo.immutable) {
                    return;
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        ComponentTypeCommands.setUnit((WriteGraph)graph, (Resource)(this).ComponentTypeViewerData.this.componentType, (Resource)propertyInfo.resource, (String)newValue);
                    }
                });
            }
        };
        combo.setFocus();
        editor.setEditor((Control)combo, selectedItem, column);
        combo.addListener(27, listener);
        combo.addListener(31, listener);
    }

    public void editValue(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, int column, final StringWriter writer, final Function4<RequestProcessor, Resource, Resource, String, String> validator) {
        int extraStyle = writer == null ? 8 : 0;
        final Text text = new Text((Composite)table, extraStyle);
        text.setText(selectedItem.getText(column));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                String error;
                if (e.type == 31) {
                    if (e.detail == 2) {
                        text.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                }
                final String newValue = text.getText();
                if (e.type == 31) {
                    e.doit = false;
                }
                text.dispose();
                if (validator != null && (error = (String)validator.apply((Object)Simantics.getSession(), (Object)ComponentTypeViewerData.this.componentType, (Object)propertyInfo.resource, (Object)newValue)) != null) {
                    return;
                }
                if (writer != null) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            writer.perform(graph, newValue);
                        }
                    });
                }
            }
        };
        text.selectAll();
        text.setFocus();
        editor.setEditor((Control)text, selectedItem, column);
        text.addListener(16, listener);
        text.addListener(31, listener);
        if (validator != null) {
            Listener validationListener = new Listener(){
                private ScheduledFuture<?> future;

                public void handleEvent(Event e) {
                    String newValue = text.getText();
                    if (this.future != null && !this.future.isCancelled()) {
                        this.future.cancel(true);
                    }
                    this.future = ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> {
                        String error = (String)validator.apply((Object)Simantics.getSession(), (Object)ComponentTypeViewerData.this.componentType, (Object)componentTypeViewerPropertyInfo.resource, (Object)newValue);
                        if (!text.isDisposed()) {
                            text.getDisplay().asyncExec(() -> {
                                if (!text.isDisposed()) {
                                    if (error != null) {
                                        text.setBackground(text.getDisplay().getSystemColor(3));
                                        text.setToolTipText(error);
                                        return;
                                    }
                                    text.setBackground(null);
                                    text.setToolTipText(null);
                                }
                            });
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                }
            };
            text.addListener(24, validationListener);
        }
    }

    private Range parseRange(NumberType numberType, String minStr, String maxStr, boolean lowInclusive, boolean highInclusive) throws RangeException {
        try {
            String rangeStr = (lowInclusive ? "[" : "(") + minStr + ".." + maxStr + (highInclusive ? "]" : ")");
            return Range.valueOf((String)rangeStr);
        }
        catch (IllegalArgumentException e) {
            throw new RangeException(e.getMessage(), (Throwable)e);
        }
    }

    private static Combo createRangeInclusionCombo(Composite parent, boolean inclusive) {
        Combo rng = new Combo(parent, 8);
        rng.add(Messages.ComponentTypeViewerData_Inclusive);
        rng.add(Messages.ComponentTypeViewerData_Exclusive);
        rng.select(inclusive ? 0 : 1);
        return rng;
    }

    protected void editRange(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, Rectangle selectedItemBounds, int column) {
        if (propertyInfo.numberType == null) {
            return;
        }
        int extraTextStyle = propertyInfo.immutable ? 8 : 0;
        Range range = null;
        String rangeStr = selectedItem.getText(column);
        try {
            range = Range.valueOf((String)rangeStr);
        }
        catch (RangeException rangeException) {
            range = new Range(Limit.nolimit(), Limit.nolimit());
        }
        final Shell shell = new Shell(table.getShell(), 16384);
        GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
        Composite composite = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        Label low = new Label(composite, 0);
        low.setText(Messages.ComponentTypeViewerData_MinimumValue);
        final Text lowText = new Text(composite, 0x800 | extraTextStyle);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)lowText);
        final Combo lowSelector = ComponentTypeViewerData.createRangeInclusionCombo(composite, !range.getLower().isExclusive());
        Label high = new Label(composite, 0);
        high.setText(Messages.ComponentTypeViewerData_MaximumValue);
        final Text highText = new Text(composite, 0x800 | extraTextStyle);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, -1).applyTo((Control)highText);
        final Combo highSelector = ComponentTypeViewerData.createRangeInclusionCombo(composite, !range.getUpper().isExclusive());
        Composite buttonComposite = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 4).applyTo((Control)buttonComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).applyTo(buttonComposite);
        Button ok = new Button(buttonComposite, 0);
        ok.setText(IDialogConstants.OK_LABEL);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)ok);
        Button cancel = new Button(buttonComposite, 0);
        cancel.setText(IDialogConstants.CANCEL_LABEL);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)ok);
        if (range.getLower().getValue() != null) {
            lowText.setText(range.getLower().getValue().toString());
        }
        if (range.getUpper().getValue() != null) {
            highText.setText(range.getUpper().getValue().toString());
        }
        shell.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
            }
        });
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Range newRange = ComponentTypeViewerData.this.parseRange(propertyInfo.numberType, lowText.getText().trim(), highText.getText().trim(), lowSelector.getSelectionIndex() == 0, highSelector.getSelectionIndex() == 0);
                    shell.dispose();
                    if (propertyInfo.immutable) {
                        return;
                    }
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            ComponentTypeCommands.setRange((WriteGraph)graph, (Resource)(this).ComponentTypeViewerData.this.componentType, (Resource)propertyInfo.resource, newRange == null ? null : newRange.toString());
                        }
                    });
                }
                catch (RangeException ex) {
                    ErrorLogger.defaultLogError((Throwable)ex);
                }
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                shell.dispose();
            }
        });
        shell.pack();
        Point size = shell.getSize();
        Display display = table.getDisplay();
        Rectangle clientArea = display.getClientArea();
        Point bt = table.toDisplay(selectedItemBounds.x, selectedItemBounds.y);
        Rectangle b = selectedItemBounds;
        b.x = bt.x;
        b.y = bt.y;
        b.width = size.x;
        b.height = size.y;
        if (b.x + b.width > clientArea.width) {
            b.x -= b.x + b.width - clientArea.width;
        }
        if (b.height > clientArea.height) {
            b.height = clientArea.height;
        }
        if (b.y + b.height > clientArea.height) {
            b.y -= b.y + b.height - clientArea.height;
        }
        shell.setBounds(selectedItemBounds);
        shell.open();
    }

    public void editMultilineText(Table table, TableEditor editor, final ComponentTypeViewerPropertyInfo propertyInfo, TableItem selectedItem, Rectangle selectedItemBounds, int column, final StringWriter writer) {
        final Shell shell = new Shell(table.getShell(), 16384);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)shell);
        final StyledText text = new StyledText((Composite)shell, 0x242 | (propertyInfo.immutable ? 8 : 0));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
        text.setText(selectedItem.getText(column));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                final String newValue = text.getText();
                if (e.type == 31) {
                    if (e.detail == 2) {
                        shell.dispose();
                        e.doit = false;
                        return;
                    }
                    if (e.detail == 64 || e.detail == 32 || e.detail == 128) {
                        return;
                    }
                    if ((e.stateMask & 0x40000) == 0) {
                        return;
                    }
                    e.doit = false;
                }
                shell.dispose();
                if (propertyInfo.immutable) {
                    return;
                }
                if (writer != null) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            writer.perform(graph, newValue);
                        }
                    });
                }
            }
        };
        String helpText = propertyInfo.immutable ? Messages.ComponentTypeViewerData_ESCToClose : Messages.ComponentTypeViewerData_CtrlEnterApplyChanges;
        Label help = this.tk.createLabel((Composite)shell, helpText, 0x800800);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)help);
        help.setForeground(this.tk.getColors().createColor("fg", this.tk.getColors().getSystemColor(26)));
        Display display = table.getDisplay();
        Rectangle clientArea = display.getClientArea();
        Point bt = table.toDisplay(selectedItemBounds.x, selectedItemBounds.y);
        Rectangle b = selectedItemBounds;
        b.x = bt.x;
        b.y = bt.y;
        b.height = 200;
        if (b.x + b.width > clientArea.width) {
            b.x -= b.x + b.width - clientArea.width;
        }
        if (b.height > clientArea.height) {
            b.height = clientArea.height;
        }
        if (b.y + b.height > clientArea.height) {
            b.y -= b.y + b.height - clientArea.height;
        }
        shell.setBounds(selectedItemBounds);
        shell.open();
        text.selectAll();
        text.setFocus();
        text.addListener(31, listener);
        shell.addListener(27, listener);
    }

    private String validatePropertyName(ComponentTypeViewerPropertyInfo propertyInfo, String propertyName, Pattern namePattern) {
        if (propertyName.equals(propertyInfo.name)) {
            return null;
        }
        ComponentTypeViewerPropertyInfo[] componentTypeViewerPropertyInfoArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentTypeViewerPropertyInfo info = componentTypeViewerPropertyInfoArray[n2];
            if (propertyName.equals(info.name)) {
                return NLS.bind((String)Messages.ComponentTypeViewerData_PropertyNameInUse, (Object)propertyName);
            }
            ++n2;
        }
        componentTypeViewerPropertyInfoArray = this.connectionPoints;
        n = this.connectionPoints.length;
        n2 = 0;
        while (n2 < n) {
            ComponentTypeViewerPropertyInfo cp = componentTypeViewerPropertyInfoArray[n2];
            if (propertyName.equals(cp.getName())) {
                return NLS.bind((String)Messages.ComponentTypeViewerData_NameInUse, (Object)propertyName);
            }
            ++n2;
        }
        Matcher m = namePattern.matcher(propertyName);
        if (!m.matches()) {
            return NLS.bind((String)Messages.ComponentTypeViewerData_ContainsInvalidCharacters, (Object)propertyName, (Object)namePattern.pattern());
        }
        return null;
    }
}

