/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import java.awt.geom.Point2D;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInput;

public abstract class CreateShapeHandler
extends AbstractHandler {
    public abstract String getDefaultElementData();

    public Object addElement(final double mposX, final double mposY, final Resource composite) {
        final String data = this.getDefaultElementData();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
                G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
                Resource svgElement = GraphUtils.create((WriteGraph)g, (Object[])new Object[]{L0.InstanceOf, dr.SVGElement, g2d.HasSVGDocument, data});
                g.addLiteral(svgElement, dr.HasTransform, dr.IsTransformOf, g2d.Transform, (Object)new double[]{1.0, 0.0, 0.0, 1.0, mposX, mposY}, (Binding)Bindings.DOUBLE_ARRAY);
                OrderedSetUtils.add((WriteGraph)g, (Resource)composite, (Resource)svgElement);
                g.claim(composite, L0.ConsistsOf, svgElement);
                AddElement.claimFreshElementName((WriteGraph)g, (Resource)composite, (Resource)svgElement);
            }
        });
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart ap = HandlerUtil.getActivePart((ExecutionEvent)event);
        IEditorPart viewer = null;
        if (ap instanceof MultiPageEditorPart) {
            IEditorPart[] eps;
            block8: {
                MultiPageEditorPart rfe = (MultiPageEditorPart)ap;
                ResourceEditorInput in = (ResourceEditorInput)rfe.getEditorInput();
                final ResourceArray ra = in.getResourceArray();
                try {
                    ResourceArray symbolEditorInput = (ResourceArray)Simantics.getSession().syncRequest((Read)new Read<ResourceArray>(){

                        public ResourceArray perform(ReadGraph graph) throws DatabaseException {
                            StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
                            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                            Resource symbol = graph.getPossibleObject(ra.resources[0], mr.ComponentTypeToSymbol);
                            Resource definedBy = symbol != null ? graph.getPossibleObject(symbol, sr.IsDefinedBy) : null;
                            ResourceArray result = definedBy != null ? new ResourceArray(new Resource[]{definedBy}) : ResourceArray.EMPTY;
                            return result;
                        }
                    });
                    eps = rfe.findEditors((IEditorInput)new ResourceEditorInput("org.simantics.modeling.ui.symbolEditor", symbolEditorInput));
                    if (eps.length != 0) break block8;
                    System.out.println("symbol editor part not found from multi page editor part: " + String.valueOf(ap));
                    return null;
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            viewer = eps[0];
        }
        if (ap instanceof IEditorPart) {
            viewer = (IEditorPart)ap;
        } else {
            return null;
        }
        ICanvasContext ctx = (ICanvasContext)viewer.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            System.out.println("No canvas context");
            return null;
        }
        MouseUtil.MouseInfo minfo = ((MouseUtil)ctx.getSingleItem(MouseUtil.class)).getMousePressedInfo(0);
        if (minfo == null) {
            System.out.println("No mouse info");
            return null;
        }
        Point2D mpos = minfo.canvasPosition;
        IResourceEditorInput input = (IResourceEditorInput)viewer.getEditorInput();
        Resource composite = input.getResource();
        return this.addElement(mpos.getX(), mpos.getY(), composite);
    }
}

