package org.simantics.modeling.ui.scl.expressions;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.simantics.scl.db.SCLExpressionTableEntry;

public class SCLExpressionItemFilter extends ViewerFilter {

    private String searchString;

    public void setSearchText(String s) {
        // ensure that the value can be used for matching
        this.searchString = (".*" + s + ".*").toLowerCase();
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (searchString == null || searchString.length() == 0)
            return true;
        SCLExpressionTableEntry entry = (SCLExpressionTableEntry) element;
        if (entry.getContent().toLowerCase().matches(searchString))
            return true;
        return false;
    }
}