/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.image;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public enum SubscriptionImageRule implements ImageRule {

    INSTANCE;

    public static SubscriptionImageRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Resource subscription = (Resource) content;

        ModelingResources MOD = ModelingResources.getInstance(graph);
        Boolean enabled = graph.getPossibleRelatedValue(subscription, MOD.Subscription_Enabled, Bindings.BOOLEAN);
        ImageDescriptor img = ImageDescriptor.getMissingImageDescriptor();
        if (enabled != null)
            img = enabled ? Activator.SUBSCRIPTION_ICON : Activator.SUBSCRIPTION_DISABLED_ICON ;

        return ArrayMap.make(ColumnKeys.KEYS_SINGLE, img);
    }

}
