/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;

@Deprecated
public abstract class StatementPredicateNode implements INode {

    protected Statement statement;

    public StatementPredicateNode(Statement resource) {
        assert resource != null;
        this.statement = resource;
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
        return LabelerUtil.safeStringRepresentation(g, statement.getPredicate());
    }

    @Override
    public int getCategory(ReadGraph graph) throws DatabaseException {
        return 0;
    }

    @Override
    public Modifier getModifier(Session session, String columnId) {
        return null;
    }

    @Override
    public boolean hasChildren(ReadGraph g) throws DatabaseException {
        return !getChildren(g).isEmpty();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Resource.class)
            return statement.getPredicate();
        if (adapter == Statement.class)
            return statement;
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null)
            return false;
        return getClass().equals(obj.getClass()) && statement.equals(((StatementPredicateNode)obj).statement);
    }

    @Override
    public int hashCode() {
        return getClass().hashCode()*31 + statement.hashCode();
    }

    @Override
    public void handleDrop(Session session, ISelection data) {
    }

}
