/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.Activator;

@Deprecated
public class Module implements INode, Comparable<Module> {

    public String label;
    public Resource resource;
    ModuleParent parent;

    public Module(String label, Resource resource, ModuleParent parent) {
        this.label = label;
        this.resource = resource;
        this.parent = parent;
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) {
        return Collections.emptyList();
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.BULLET_GREEN_ICON;
    }

    @Override
    public String getLabel(ReadGraph g) {
        return label;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!getClass().equals(obj.getClass()))
            return false;
        Module other = (Module)obj;
        return label.equals(other.label) && resource.equals(other.resource) && Objects.equals(parent, other.parent);
    }

    @Override
    public int hashCode() {
        return (label.hashCode() * 31 + resource.hashCode()) * 31 + Objects.hashCode(parent);
    }

    @Override
    public Modifier getModifier(final Session session, String columnId) {
        return null;
    }

    @Override
    public int getCategory(ReadGraph graph) {
        return 0;
    }

    @Override
    public void handleDrop(Session session, ISelection selection) {
    }

    @Override
    public void handleDelete(WriteGraph graph) throws DatabaseException {
    }

    @Override
    public boolean hasChildren(ReadGraph graph) {
        return false;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Resource.class)
            return resource;
        if (adapter == ResourceArray.class) {
            int len = 1;
            for (ModuleParent parent = this.parent; parent != null; parent = parent.parent, ++len);
            Resource[] result = new Resource[len];
            result[0] = resource;
            ModuleParent parent = this.parent;
            for (int i = 1; i < len; ++i) {
                result[i] = parent.resource;
                parent = parent.parent;
            }
            return new ResourceArray(result);
        }
        return null;
    }

    @Override
    public int compareTo(Module arg0) {
        return label.compareTo(arg0.label);
    }

}
