/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletable;
import org.simantics.browsing.ui.common.node.IModifiable;
import org.simantics.browsing.ui.common.node.IRefreshable;
import org.simantics.browsing.ui.content.Labeler.Modifier;

/**
 * INode2 represents a node in the background system object model.
 * 
 * @see IDeletable
 * @see IModifiable
 * @see IRefreshable
 * @see IOpenable
 * 
 * @deprecated <a href="https://www.simantics.org/wiki/index.php/Org.simantics.browsing.ui_Manual">tutorial for new features</a>
 */
@Deprecated
public interface INode2 extends IAdaptable {
    String getLabel(Runnable updater, NodeContext context);
    int getCategory(Runnable updater, NodeContext context);
    Collection<?> getChildren(Runnable updater, NodeContext context);
    boolean hasChildren(Runnable updater, NodeContext context);
    ImageDescriptor getImage(Runnable updater, NodeContext context);
    Modifier getModifier(String columnId);

    /**
     * Delete node in the background system. The node is considered deletable
     * only if it implements {@link IDeletable}.
     * 
     * @throws DeleteException if node could not be deleted
     */
    void handleDelete() throws DeleteException;

}
