/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.genericfileimport.wizard;

import java.io.File;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Antti Villberg
 */
public class GenericFileImportPage extends WizardPage {

    /**
     * If non-null, the wizard cannot continue. This message tells why.
     */
    String              failure;

    GenericFileImportPlan          importModel;

    CCombo              importLocation;

    protected GenericFileImportPage(GenericFileImportPlan model) {
        super("Import File", "Define Import Location", null);
        this.importModel = model;
    }

    @Override
    public void createControl(Composite parent) {
        Composite container = new Composite(parent, SWT.NONE);
        {
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 20;
            layout.verticalSpacing = 10;
            layout.numColumns = 3;
            container.setLayout(layout);
        }
        
        new Label(container, SWT.NONE).setText("&File:");
        importLocation = new CCombo(container, SWT.BORDER);
        {
            importLocation.setText("");
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(importLocation);
            importLocation.addModifyListener(new ModifyListener(){
                @Override
                public void modifyText(ModifyEvent e) {
                    validatePage();
                }
            });
        }
        Button browseFileButton = new Button(container, SWT.PUSH);
        {
            browseFileButton.setText("Br&owse...");
            browseFileButton.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
            browseFileButton.addSelectionListener(new SelectionAdapter() {
                @Override
                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(getShell(), SWT.OPEN);
                    dialog.setText("Choose File to Import");
                    String loc = importLocation.getText();
                    dialog.setFilterPath(loc);
                    dialog.setFilterExtensions(new String[] { "*.*" });
                    dialog.setFilterNames(new String[] { "All files" });
                    String file = dialog.open();
                    if (file == null)
                        return;
                    importLocation.setText(file);
                    validatePage();
                }
            });
        }

        try {
            initializeData();
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }

        setControl(container);
        validatePage();
        
    }

    private void initializeData() throws DatabaseException {
        for (String path : importModel.recentLocations) {
            importLocation.add(path);
        }
        if (importLocation.getItemCount() > 0)
            importLocation.select(0);
    }

    void validatePage() {
    	
        if (failure != null) {
            setErrorMessage(failure);
            setPageComplete(false);
            return;
        }
        String importLoc = importLocation.getText();
        if (importLoc.isEmpty()) {
            setMessage("Select file to import.");
            setErrorMessage(null);
            setPageComplete(false);
            return;
        }
        File file = new File(importLoc);
        if (!file.exists() || !file.isFile()) {
            setErrorMessage("Selected file is invalid.");
            setPageComplete(false);
            return;
        }
        importModel.importLocation = file;

        setErrorMessage(null);
        setMessage("Ready to import " + file.getName() + "");
        setPageComplete(true);

    }

}
