/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.Scale;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.selectionview.ConfigurationComposite;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ChartComposite extends ConfigurationComposite {

    public static final TimeInputValidator LENGTH_VALIDATOR = new TimeInputValidator(1.0);
    public static final TimeInputValidator START_VALIDATOR = new TimeInputValidator(-Double.MAX_VALUE);	

    public static Read<String> getPartTitleRequest(final ISelection selection) {
        return new Read<String>() {
            @Override
            public String perform(ReadGraph graph) throws DatabaseException {
                Resource r = ResourceAdaptionUtils.toSingleResource(selection);
                if (r == null)
                    return "Selection"; //$NON-NLS-1$
                return NameLabelUtil.modalName(graph, r);
            }
        };
    }

    @Override
    public Read<String> getPartNameReadRequest(ISelection forSelection) {
    	return getPartTitleRequest(forSelection);
    }

    public void create(final Composite body, IWorkbenchSite site, final ISessionContext context, final WidgetSupport support) {
        final Display display = body.getDisplay();

        body.setBackground(display.getSystemColor(SWT.COLOR_WHITE));

/*        Composite buttonComposite = new Composite(body, SWT.NONE);
        buttonComposite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5,5,5,5).applyTo(buttonComposite);
        
        Label nameHeader = new Label(buttonComposite, support, 0);
        nameHeader.setText("Name");
        //nameHeader.setFont(smallFont);
        nameHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(nameHeader.getWidget());

        TrackedText nameText = new TrackedText(buttonComposite, support, SWT.BORDER | SWT.FLAT);
        nameText.setTextFactory(new StringPropertyFactory(Layer0.URIs.HasName, ""));
        nameText.addModifyListener(new StringPropertyModifier(context, Layer0.URIs.HasName));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo(nameText.getWidget());
*/
        Label autoscrollLabel = new Label(body, support, 0);
        autoscrollLabel.setText(Messages.ChartComposite_AutoScrollSettings);
        autoscrollLabel.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(autoscrollLabel.getControl());
        
        Composite templateComposite = new Composite(body, SWT.NONE);
        templateComposite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(templateComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(3).extendedMargins(5,5,5,5).applyTo(templateComposite);

        Label templateHeader = new Label(templateComposite, support, 0);
        templateHeader.setText(Messages.ChartComposite_Template);
        //templateHeader.setFont(smallFont);
        templateHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(templateHeader.getWidget());

        Combo templateCombo = new Combo(templateComposite, support, SWT.NONE | SWT.READ_ONLY);
        templateCombo.setItemFactory(new AvailableTemplateFactory());
        templateCombo.setSelectionFactory(new CurrentTemplateFactory());
        templateCombo.addModifyListener(new TemplateModifier());
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(templateCombo.getWidget());

        Button resetButton = new Button(templateComposite, support, SWT.NONE | SWT.READ_ONLY);
        resetButton.setText(Messages.ChartComposite_Apply);
        resetButton.addSelectionListener(new SelectionListenerImpl<Resource>(context) {
            @Override
            public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
                graph.markUndoPoint();
                ChartResource CHART = ChartResource.getInstance(graph);
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowStart))
                    graph.deny(monitor, CHART.Chart_TimeWindowStart);
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowLength))
                    graph.deny(monitor, CHART.Chart_TimeWindowLength);
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowIncrement))
                    graph.deny(monitor, CHART.Chart_TimeWindowIncrement);
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo(resetButton.getWidget());

        Composite buttonComposite = new Composite(body, SWT.NONE);
        buttonComposite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo(buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5,5,5,5).applyTo(buttonComposite);

        Label startHeader = new Label(buttonComposite, support, 0);
        startHeader.setText(Messages.ChartComposite_StartTime);
        //startHeader.setFont(smallFont);
        startHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(startHeader.getWidget());

        TrackedText timeWindowStart = new TrackedText(buttonComposite, support, SWT.BORDER | SWT.FLAT);
        timeWindowStart.getWidget().setToolTipText(Messages.ChartComposite_ChartWindowTT);
        timeWindowStart.setTextFactory(new TimePropertyFactory(ChartResource.URIs.Chart_TimeWindowStart));
        timeWindowStart.addModifyListener(new TimePropertyModifier(context, ChartResource.URIs.Chart_TimeWindowStart, START_VALIDATOR));
        timeWindowStart.setInputValidator( START_VALIDATOR );
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo(timeWindowStart.getWidget());

//        Label l1 = new Label(buttonComposite, support, 0);
//        l1.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        l1.setText("seconds");

        Label sizeHeader = new Label(buttonComposite, support, 0);
        sizeHeader.setText(Messages.ChartComposite_Length);
        //sizeHeader.setFont(smallFont);
        sizeHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(sizeHeader.getWidget());

        TrackedText timeWindowLength = new TrackedText(buttonComposite, support, SWT.BORDER | SWT.FLAT);
        timeWindowLength.getWidget().setToolTipText(Messages.ChartComposite_ChartWindowTT2);
        timeWindowLength.setTextFactory(new TimePropertyFactory(ChartResource.URIs.Chart_TimeWindowLength));
        timeWindowLength.addModifyListener(new TimePropertyModifier(context, ChartResource.URIs.Chart_TimeWindowLength, LENGTH_VALIDATOR));
        timeWindowLength.setInputValidator( LENGTH_VALIDATOR );
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo(timeWindowLength.getWidget());

//        Label l2 = new Label(buttonComposite, support, 0);
//        l2.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
//        l2.setText("seconds");

        Label incrementHeader = new Label(buttonComposite, support, 0);
        incrementHeader.setText(Messages.ChartComposite_ScrollIncrement);
        //incrementHeader.setFont(smallFont);
        incrementHeader.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(SWT.LEFT, SWT.CENTER).applyTo(incrementHeader.getWidget());

        Scale timeWindowIncrement = new Scale(buttonComposite, support, SWT.READ_ONLY);
        timeWindowIncrement.getWidget().setMinimum(1);
        timeWindowIncrement.getWidget().setMaximum(100);
        timeWindowIncrement.getWidget().setIncrement(10);
        timeWindowIncrement.getWidget().setPageIncrement(10);
        timeWindowIncrement.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        timeWindowIncrement.setSelectionFactory(new DoubleToIntegerPropertyFactory(ChartResource.URIs.Chart_TimeWindowIncrement));
        timeWindowIncrement.addSelectionListener(new DelayedIntegerToDoublePropertyModifier(timeWindowIncrement, context, ChartResource.URIs.Chart_TimeWindowIncrement));
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(timeWindowIncrement.getWidget());

        TrackedText timeWindowIncrementText = new TrackedText(buttonComposite, support, SWT.BORDER | SWT.FLAT);
        timeWindowIncrementText.setTextFactory(new DoublePropertyFactory(ChartResource.URIs.Chart_TimeWindowIncrement));
        timeWindowIncrementText.addModifyListener(new DoublePropertyModifier(context, ChartResource.URIs.Chart_TimeWindowIncrement));
        timeWindowIncrementText.setInputValidator(new IInputValidator() {
            @Override
            public String isValid(String newText) {
                if (newText.trim().isEmpty())
                    return null;
                try {
                    Double d = Double.parseDouble(newText);
                    if (d < 1 || d > 100)
                        return Messages.ChartComposite_ScrollIncrementRange;
                    return null;
                } catch (NumberFormatException e) {
                    return e.getMessage();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).align(SWT.LEAD, SWT.CENTER).span(1, 1).applyTo(timeWindowIncrementText.getWidget());

        Label l3 = new Label(buttonComposite, support, 0);
        l3.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        l3.setText("%"); //$NON-NLS-1$

        Composite checkboxComposite = new Composite(buttonComposite, SWT.NONE);
        checkboxComposite.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(checkboxComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(checkboxComposite);

        final Button showMilestones = new Button(checkboxComposite, support, SWT.CHECK);
        showMilestones.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        showMilestones.setText(Messages.ChartComposite_ShowMileStones);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(showMilestones.getWidget());
        showMilestones.setSelectionFactory(new BooleanPropertyFactory(ChartResource.URIs.Chart_ShowMilestones));
        showMilestones.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    final Resource r = ISelectionUtils.filterSingleSelection(support.getInput(), Resource.class);
                    if (r == null)
                        return;
                    final Boolean show = showMilestones.getWidget().getSelection();
                    Simantics.getSession().syncRequest(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            graph.claimLiteral(r, ChartResource.getInstance(graph).Chart_ShowMilestones, show, Bindings.BOOLEAN);
                        }
                    });
                } catch (DatabaseException e1) {
                    Activator.getDefault().getLog().log(
                            new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                                    Messages.ChartComposite_ActivatorFailedToSetShowMilestones, e1));
                }
            }
        });

        final Button trackExperimentTime = new Button(checkboxComposite, support, SWT.CHECK);
        trackExperimentTime.setBackground(display.getSystemColor(SWT.COLOR_WHITE));
        trackExperimentTime.setText(Messages.ChartComposite_HairlineAndTracksExperimentTime);
        trackExperimentTime.setTooltipText(Messages.ChartComposite_HairlineAndTracksExperimentTimeTT);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo(trackExperimentTime.getWidget());
        trackExperimentTime.setSelectionFactory(new BooleanPropertyFactory(ChartResource.URIs.Chart_trackExperimentTime));
        trackExperimentTime.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                try {
                    final Resource r = ISelectionUtils.filterSingleSelection(support.getInput(), Resource.class);
                    if (r == null)
                        return;
                    final Boolean track = trackExperimentTime.getWidget().getSelection();
                    Simantics.getSession().syncRequest(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            graph.claimLiteral(r, ChartResource.getInstance(graph).Chart_trackExperimentTime, track, Bindings.BOOLEAN);
                        }
                    });
                } catch (DatabaseException e1) {
                    Activator.getDefault().getLog().log(
                            new Status(IStatus.ERROR, Activator.PLUGIN_ID,
                                    Messages.ChartComposite_ActivatorFailedTrackExperimentTime, e1));
                }
            }
        });
    }

}
