package org.simantics.modeling.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class NewSymbol implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if (!(target instanceof Resource))
            return null;
        final Resource componentType = (Resource) target;
        return new Runnable() {
            @Override
            public void run() {
                try {
                    Simantics.getSession().syncRequest(new WriteRequest() {
                        @Override
                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            ComponentTypeCommands.createSymbol(graph, componentType);
                        }
                    });
                } catch (DatabaseException e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        };
    }

}
