package org.simantics.modeling.tests.commands;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleURIVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.diagram.adapter.DisposableListener;
import org.simantics.diagram.adapter.DisposableListenerAdapter;
import org.simantics.modeling.tests.traits.SingleResourceTrait;

public class WriteState extends WriteCommand<CommandSequenceEnvironment> {
	
	private static final long TIMEOUT = 5000000000L;
	
	transient public SingleResourceTrait run;
	transient public String rvi;
	transient public Object value;
	transient public Binding binding;
	
	public WriteState(SingleResourceTrait run, String rvi, Object value, Binding binding) {
		this.run = run;
		this.rvi = rvi;
		this.value = value;
		this.binding = binding;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws DatabaseException {

		long start = System.nanoTime();
		long current = System.nanoTime();
		
		final DisposableListener<Variable> listener = new DisposableListenerAdapter<Variable>();

		try {

			while((current-start) < TIMEOUT) {

				boolean success = environment.getSession().sync(new WriteResultRequest<Boolean>() {

					@Override
					public Boolean perform(WriteGraph graph) throws DatabaseException {

						Variable state = graph.syncRequest(new PossibleURIVariable(graph.getURI(run.getResource(graph)) + rvi), listener);
						if(state == null) return false;

						state.setValue(graph, value, binding);

						CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
						// Add comment to change set.
						graph.addMetadata(cm.add("Set value"));

						return true;

					}

				});

				if(success) return;

				try {
					Thread.sleep(1);
				} catch (InterruptedException e1) {
					throw new DatabaseException(e1);
				}

				current = System.nanoTime();

			}

			throw new DatabaseException("Timeout writing " + rvi);
			
		} finally {

			listener.disposeListener();

		}
		
	}

}