package org.simantics.modeling.tests.commands;

import java.util.concurrent.TimeUnit;

import org.simantics.Simantics;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.EvaluatingListener;
import org.simantics.db.layer0.util.EvaluatingListener.Criterion;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.tests.traits.SingleResourceTrait;



public class Utils {


	public static void waitMapping() throws DatabaseException {
		
		sync();
	    	
	}

	public static void sync() throws DatabaseException {

    	// Multiple bugs here:
    	// -Model performs activation in separate write transactions because API does not support changing the virtual graph
    	//  => activation & activation listener is delayed beyond this point
    	// -This should be fixed by the following code 
        //     TransactionSupport ts = session.getService(TransactionSupport.class);
    	//     ts.waitCompletion();
    	//  but unfortunately this does not work either...
    	// so we synchronize by a familiar write transaction

		
        // And then wait still some more
		for(int i=0;i<3;i++) {
	       Simantics.getSession().syncRequest(new WriteRequest() {
	            
	            @Override
	            public void perform(WriteGraph graph) throws DatabaseException {
	                
	            }
	        	
	        	@Override
	        	public String toString() {
	        		return "Utils sync";
	        	}
	            
	       });
	       
	       // And then wait still some more
	       Simantics.getSession().syncRequest(new ReadRequest() {
	           
	           @Override
	           public void run(ReadGraph graph) throws DatabaseException {
	               
	           }
	           
	      });
		}
       
    }
	
	public static void writeConfiguration(final Resource model, final String rvi, final Object value, final Binding binding) throws DatabaseException {
	    
	    class WriteConfiguration extends WriteRequest {

			@Override
			public void perform(WriteGraph graph) throws DatabaseException {
	            Variable state = Variables.getVariable(graph, graph.getURI(model) + rvi);
	            state.setValue(graph, value, binding);
			}
	        
	    }
	    
	    Simantics.getSession().syncRequest(new WriteConfiguration());
	    
	}
	
	public static <T>T readValue(final SingleResourceTrait run, final String rvi, final Criterion<T> criterion) throws DatabaseException, InterruptedException {

		return EvaluatingListener.<T>trySyncRequest(Simantics.getSession(), 
				new UniqueRead<T>(){
					@SuppressWarnings("unchecked")
					@Override
					public T perform(ReadGraph graph) throws DatabaseException{
						Variable state = Variables.getPossibleVariable(graph, graph.getURI(run.getResource(graph)) + rvi);
						return (T) (state != null ? state.getValue(graph) : null);
					}
					
				}, 
				criterion,
				15, TimeUnit.SECONDS);
	}

}

