package org.simantics.modeling.tests.commands;

import org.simantics.databoard.Bindings;
import org.simantics.db.DevelopmentKeys;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.utils.Development;

public class ModificationEvents extends WriteCommand<CommandSequenceEnvironment> {

	transient private boolean enable;
	
	public ModificationEvents(boolean enable) {
		this.enable = enable;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws Exception {

		if(enable) {
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG, true, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_NAMES, true, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.PRINT, false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.LOGGER_ECHO, false, Bindings.BOOLEAN);
		} else {
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG, false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_NAMES, false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.PRINT, true, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.LOGGER_ECHO, true, Bindings.BOOLEAN);
		}
		
	}

}