/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class ScenegraphChildrenRule implements ChildRule {

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Resource.class);
	}

	@Override
	public Collection<?> getChildren(ReadGraph graph, Object parent)
			throws DatabaseException {

		Resource entry = (Resource)parent;
		Layer0 L0 = Layer0.getInstance(graph);
		ScenegraphResources SG = ScenegraphResources.getInstance(graph);
		Resource list = graph.getPossibleObject(entry, SG.Node_children);
		if(list != null) {
			if(graph.isInstanceOf(list, L0.List)) return ListUtils.toList(graph, list);
		}
		return Collections.emptyList();
    }

	@Override
	public Collection<?> getParents(ReadGraph graph, Object child)
			throws DatabaseException {
		return new ArrayList<Resource>();
	}

}
