/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals.rules;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;

/**
 * Synchronizes:
 * * Grow Profile Monitors Upward?
 * * Hide Profile Monitors?
 * * Profile Monitor Offset?
 * * Profile Monitor Spacing?
 * 
 * @author Antti Villberg
 */
public enum ProfileMonitorRule implements ITypicalSynchronizationRule {

    INSTANCE;

    public static ProfileMonitorRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
    	
        DiagramResource DIA = DiagramResource.getInstance(graph);

        // TODO consider making sure HasMonitorComponent is up-to-date also even though users should not be able to modify it

        boolean changed = false;
        boolean result = changed |= Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_upProfileMonitors);
    	if(result) info.messageLog.add("\t\t\tgrow profile monitors upward => " + graph.getPossibleRelatedValue(instance, DIA.Element_upProfileMonitors));
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_hideProfileMonitors);
    	if(result) info.messageLog.add("\t\t\thide profile monitors => " +  graph.getPossibleRelatedValue(instance, DIA.Element_hideProfileMonitors));
        changed |= result;
        result = Properties.synchronizePrimitivePropertyValue(graph, template, instance, DIA.Element_profileMonitorOffset);
    	if(result) info.messageLog.add("\t\t\tprofile monitor offset => " + graph.getPossibleRelatedValue(instance, DIA.Element_profileMonitorOffset));
        changed |= result;
        result = Properties.synchronizeEnumerationPropertyValue(graph, template, instance, DIA.Element_profileMonitorSpacing);
    	if(result) info.messageLog.add("\t\t\tprofile monitor spacing => " + graph.getPossibleRelatedValue(instance, DIA.Element_profileMonitorSpacing));
        changed |= result;

        // TODO: sync font
        //changed |= Properties.synchronizeStructuredPropertyValue(graph, template, instance, G2D.HasFont);

        return changed;
    }

}
