/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.project.IProject;

/**
 * @author Tuukka Lehtonen
 * @deprecated not to be used anymore, will be removed
 */
public class TypicalSupport {

    protected IProject project;
    protected GraphChangeListenerSupport changeListenerSupport;

    private IEclipsePreferences typicalPreferences;
    private TypicalDiagramTemplateListener typicalDiagramTemplateListener;
    private IPreferenceChangeListener typicalSynchronizationPreferenceListener = new TypicalSynchronizationPreferenceListener();

    public TypicalSupport(IProject project) {
        this.project = project;
        this.changeListenerSupport = project.getSession().getService(GraphChangeListenerSupport.class);

        setTypicalSynchronization( isSyncEnabled() );
        typicalPreferences = InstanceScope.INSTANCE.getNode(TypicalPreferences.P_NODE);
        typicalPreferences.addPreferenceChangeListener(typicalSynchronizationPreferenceListener);
    }

    public void dispose() {
        if (typicalPreferences != null) {
            typicalPreferences.removePreferenceChangeListener(typicalSynchronizationPreferenceListener);
        }
        if (typicalDiagramTemplateListener != null) {
            changeListenerSupport.removeMetadataListener(typicalDiagramTemplateListener);
            typicalDiagramTemplateListener = null;
        }
    }

    public void setTypicalSynchronization(boolean enabled) {
        if (enabled) {
            if (typicalDiagramTemplateListener == null) {
                typicalDiagramTemplateListener = new TypicalDiagramTemplateListener();
                changeListenerSupport.addMetadataListener( typicalDiagramTemplateListener );
            }
        } else {
            if (typicalDiagramTemplateListener != null) {
                changeListenerSupport.removeMetadataListener( typicalDiagramTemplateListener );
                typicalDiagramTemplateListener = null;
            }
        }
    }

    private boolean isSyncEnabled() {
        return InstanceScope.INSTANCE
                .getNode(TypicalPreferences.P_NODE)
                .getBoolean(
                        TypicalPreferences.P_REALTIME_TYPICAL_SYNC_ENABLED,
                        TypicalPreferences.DEFAULT_REALTIME_TYPICAL_SYNC_ENABLED);
    }

    private class TypicalSynchronizationPreferenceListener implements IPreferenceChangeListener {
        @Override
        public void preferenceChange(PreferenceChangeEvent event) {
            if (project == null || project.isDisposed())
                return;

            if (TypicalPreferences.P_REALTIME_TYPICAL_SYNC_ENABLED.equals(event.getKey())) {
                boolean enabled = isSyncEnabled();
                setTypicalSynchronization(enabled);
            }
        }
    }

}
