/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.util;

public final class TagUtil {
    public static String nop(String text) {
        return text;
    }

    public static String tag(String s, String tag) {
        if (tag == null) {
            return s;
        }
        StringBuilder b = new StringBuilder(s.length() + tag.length() * 2 + 6);
        b.append('<');
        b.append(tag);
        b.append('>');
        b.append(s);
        b.append("</");
        b.append(tag);
        b.append('>');
        return b.toString();
    }

    public static String tag(String s, String tag, String ... attrs) {
        assert (attrs.length % 2 == 0);
        StringBuilder b = new StringBuilder(s.length() + tag.length() * 2 + 30);
        b.append('<');
        b.append(tag);
        int i = 0;
        while (i < attrs.length) {
            b.append(' ');
            b.append(attrs[i]);
            b.append("=\"");
            b.append(attrs[i + 1]);
            b.append('\"');
            i += 2;
        }
        b.append('>');
        b.append(s);
        b.append("</");
        b.append(tag);
        b.append('>');
        return b.toString();
    }

    private static boolean isEnclosed(String s, String tag) {
        boolean endTag;
        String trim = s.trim();
        int tagLen = tag.length();
        int len = trim.length();
        boolean startTag = len >= tag.length() + 2 && trim.charAt(0) == '<' && trim.startsWith(tag, 1) && trim.charAt(1 + tagLen) == '>';
        boolean bl = endTag = len >= tag.length() * 2 + 5 && trim.startsWith("</", len - 1 - tagLen - 2) && trim.startsWith(tag, 1) && trim.charAt(len - 1) == '>';
        return startTag && endTag;
    }

    public static void main(String[] args) {
        TagUtil.assertTrue(!TagUtil.isEnclosed("form", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("<form></form>", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("<form>    </form>", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("   <form></form>", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("<form></form>   ", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("   <form></form>   ", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("<form>FOO</form>", "form"));
        TagUtil.assertTrue(TagUtil.isEnclosed("<form>   FOO </form>", "form"));
    }

    private static void assertTrue(boolean b) {
        if (!b) {
            throw new AssertionError(false);
        }
    }
}

