/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSerializer;
import org.simantics.db.Session;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.message.ReferenceSerializationException;

public class ResourceSerializerUtil {
    public static Resource deserialize(Session s, URI data) throws ReferenceSerializationException {
        SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
        ResourceSerializer rs = support.getResourceSerializer();
        try {
            return rs.getResource(data.getSchemeSpecificPart());
        }
        catch (InvalidResourceReferenceException e) {
            throw new ReferenceSerializationException(e);
        }
    }

    public static URI serialize(Session s, Resource r) throws ReferenceSerializationException {
        SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
        ResourceSerializer rs = support.getResourceSerializer();
        try {
            return new URI("resource", rs.createRandomAccessId(r), null);
        }
        catch (InvalidResourceReferenceException e) {
            throw new ReferenceSerializationException(e);
        }
        catch (URISyntaxException e) {
            throw new ReferenceSerializationException(e);
        }
    }
}

