/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message;

import java.net.URI;

/**
 * @author Tuukka Lehtonen
 */
public interface IReferenceSerializer {

    /**
     * @param o
     * @return
     */
    boolean handles(Object o);

    /**
     * @param o
     * @return
     * @throws ReferenceSerializationException
     */
    URI serialize(Object o) throws ReferenceSerializationException;

    /**
     * @param s
     * @return
     * @throws ReferenceSerializationException
     */
    Object deserialize(URI data) throws ReferenceSerializationException;

}
