/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ProfileRuleInstruction
implements IRuleInstruction {
    String name;
    IRuleInstruction rule;

    public ProfileRuleInstruction(String name, IRuleInstruction rule) {
        this.name = name;
        this.rule = rule;
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.rule.collectVariables(reads, writes);
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(this.name + ".execute");
        final IModification modi = this.rule.execute(g, bindings);
        task.finish();
        if (modi == null) {
            return null;
        }
        return new IModification(){

            public void perform(WriteGraph g) throws DatabaseException {
                ITask task = ThreadLogger.getInstance().begin(ProfileRuleInstruction.this.name + ".perform");
                modi.perform(g);
                task.finish();
            }
        };
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        ITask task = ThreadLogger.getInstance().begin(this.name + ".doExecute");
        this.rule.doExecute(g, bindings);
        task.finish();
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.rule.mapVariables(map);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        this.rule.toString(b, indent);
    }
}

