/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.Instruction1;

public class UnaryPredicateInstruction
extends Instruction1 {
    IUnaryPredicate predicate;

    public UnaryPredicateInstruction(int variable0, IUnaryPredicate predicate) {
        super(variable0);
        this.predicate = predicate;
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        if (this.predicate.has(g, (Resource)bindings[this.variable0])) {
            return null;
        }
        return IInstruction.FAILURE;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) {
        return IInstruction.FAILURE;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource r = (Resource)bindings[this.variable0];
        if (!this.predicate.has(g, r)) {
            return new IContextualModification(){

                @Override
                public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                    UnaryPredicateInstruction.this.predicate.add(g, (Resource)bindings[UnaryPredicateInstruction.this.variable0]);
                }
            };
        }
        return null;
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        this.predicate.add(g, r0);
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        Resource r = (Resource)bindings[this.variable0];
        if (this.predicate.has(g, r)) {
            return new IContextualModification(){

                @Override
                public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                    UnaryPredicateInstruction.this.predicate.remove(g, (Resource)bindings[UnaryPredicateInstruction.this.variable0]);
                }
            };
        }
        return null;
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource r0 = (Resource)bindings[this.variable0];
        if (this.predicate.has((ReadGraph)g, r0)) {
            this.predicate.remove(g, r0);
        }
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append('(');
        b.append(this.variable0);
        b.append(')');
    }
}

