/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import java.util.Arrays;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class ClaimRuleInstruction implements IRuleInstruction {

	IInstruction instruction;	
	IRuleInstruction continuation;
	
	public ClaimRuleInstruction(IInstruction instruction,
		IRuleInstruction continuation) {
		this.instruction = instruction;
		this.continuation = continuation;
	}

	public ClaimRuleInstruction(IInstruction instruction) {
		this(instruction, null);
	}
	
	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		final IContextualModification modi = instruction.claim(g, bindings);
		if(modi != null) {
			final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);
			return new IModification() {

				@Override
				public void perform(WriteGraph g) throws DatabaseException {
					modi.perform(g, curBindings);
					if(continuation != null) {
						IModification modi2 = continuation.execute(g, curBindings);
						if(modi2 != null)
							modi2.perform(g);
					}
				}
				
			};
		}
		if(continuation != null)
			return continuation.execute(g, bindings);
		return null;
	}
	
	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		instruction.doClaim(g, bindings);
	}
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		instruction.collectVariables(reads, writes);
		if(continuation != null)
			continuation.collectVariables(reads, writes);
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		instruction.mapVariables(map);
		if(continuation != null)
			continuation.mapVariables(map);
	}
	@Override
	public void toString(StringBuilder b, int indent) {
		b.append("claim ");
		instruction.toString(b, indent+1);
		if(continuation != null) {
			b.append('\n');
			for(int i=0;i<indent;++i)
				b.append(INDENTATION);
			b.append("and ");
			continuation.toString(b, indent+1);
		}
	}
}
