/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import java.util.Arrays;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;

public class AndRuleInstruction implements IRuleInstruction {
	IRuleInstruction[] rules;

	public AndRuleInstruction(IRuleInstruction ... rules) {
		this.rules = rules;
	}

	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		for(int i=0;i<rules.length;++i) {
			if(DEBUG)
			    System.out.println("AndRuleInstruction.execute " + i + "/" + rules.length);
			IRuleInstruction rule = rules[i];
			final IModification modi = rule.execute(g, bindings);
			if(modi != null) {
				final int si = i+1;
				if(si==rules.length)
					return modi;
				else {
					final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);					
					return new IModification() {

						@Override
						public void perform(WriteGraph g) throws DatabaseException {
							modi.perform(g);
							for(int j=si;j<rules.length;++j)
								rules[j].doExecute(g, curBindings);
						}
						
						@Override
						public String toString() {
						    StringBuilder b = new StringBuilder();
						    b.append("AndRuleInstruction");
						    for(IRuleInstruction i : rules) i.toString(b, 2);
						    return b.toString();
						}
						
					};
				}
			}
		}
		return null;
	}
	
	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		for(IRuleInstruction rule : rules)
			rule.doExecute(g, bindings);
	}
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		for(IRuleInstruction r : rules)
			r.collectVariables(reads, writes);
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		for(IRuleInstruction r : rules)
			r.mapVariables(map);
	}
	
	@Override
	public void toString(StringBuilder b, int indent) {
		for(IRuleInstruction rule : rules)
			rule.toString(b, indent);
	}
}
