/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.set.hash.TIntHashSet;

import java.util.Collection;
import java.util.Iterator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class TripletObjectQuery extends TripletInstruction {

	public TripletObjectQuery(int variable0, int variable1, int variable2) {
		super(variable0, variable1, variable2);	
	}
	
	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
		Resource r1 = (Resource)bindings[variable1];
		Collection<Resource> result = g.getObjects(r0, r1);
		if(result.isEmpty())
			return IInstruction.FAILURE;
		Iterator<Resource> it = result.iterator();
		bindings[variable2] = it.next();
		if(it.hasNext())
			return it;
		else
			return null;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) {
		Iterator<Resource> it = (Iterator<Resource>)continuation;
		if(it.hasNext()) {
			bindings[variable2] = it.next();
			if(it.hasNext())
				return it;
			else
				return null;
		}
		else
			return IInstruction.FAILURE;
	}	
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {		
		super.collectVariables(reads, writes);
		writes.add(variable2);
	}

}
