/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.UnaryPredicateInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class UnaryPredicateConstraint implements IConstraint {

	Resource variable0;
	IUnaryPredicate predicate;	
	
	public UnaryPredicateConstraint(IUnaryPredicate predicate, Resource variable0) {
		this.predicate = predicate;
		this.variable0 = variable0;
	}

	@Override
	public ImmutableSet<Resource> binds() {
		return ImmutableSet.of(variable0);
	}

	@Override
	public IInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds,
			ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
		if(!bound.contains(variable0))
			throw new TooManyUnboundVariablesException();
		return new UnaryPredicateInstruction(variableIds.get(variable0), predicate);
	}

	@Override
	public int isApplicable(ImmutableSet<Resource> bound) {
		return bound.contains(variable0) ? Integer.MAX_VALUE : 0;
	}

}
