/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint;

import gnu.trove.map.hash.TObjectIntHashMap;

import org.simantics.db.Resource;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.TripletInstruction;
import org.simantics.mapping.constraint.instructions.TripletObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletPredicateObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletPredicateQuery;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class TripletConstraint implements IConstraint {

	Resource variable0;
	Resource variable1;
	Resource variable2;
	Resource predicate;		

	public TripletConstraint(Resource variable0, Resource variable1,
			Resource variable2, Resource predicate) {		
		this.variable0 = variable0;
		this.variable1 = variable1;
		this.variable2 = variable2;
		this.predicate = predicate;
	}
	
	public TripletConstraint(Resource variable0, Resource variable1,
			Resource variable2) {
		this(variable0, variable1, variable2, null);
	}

	@Override
	public ImmutableSet<Resource> binds() {
		return ImmutableSet.of(variable0, variable1, variable2);
	}

	@Override
	public IInstruction createInstruction(
			TObjectIntHashMap<Resource> variableIds,
			ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
		int id0 = variableIds.get(variable0);
		int id1 = variableIds.get(variable1);
		int id2 = variableIds.get(variable2);
		if(bound.contains(variable0)) {
			if(bound.contains(variable1)) {
				if(bound.contains(variable2))
					return new TripletInstruction(id0, id1, id2);
				else
					return new TripletObjectQuery(id0, id1, id2);
			}
			else {
				if(bound.contains(variable2))
					return new TripletPredicateQuery(id0, id1, id2, predicate);
				else
					return new TripletPredicateObjectQuery(id0, id1, id2, predicate);
			}		
		}
		else {
			throw new TooManyUnboundVariablesException();			
		}
	}

	@Override
	public int isApplicable(ImmutableSet<Resource> bound) {
		if(bound.contains(variable0))
			return Integer.MAX_VALUE;
		else
			return 0;
	}

}
