/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.lz4.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

import org.simantics.compressions.impl.DecompressingInputStream;
import org.simantics.lz4.LZ4;


/**
 * @author Tuukka Lehtonen
 */
public class LZ4InputStream extends DecompressingInputStream {

    public LZ4InputStream(File file) throws FileNotFoundException {
        super(file);
    }

    public LZ4InputStream(FileInputStream stream) {
        super(stream);
    }
    
    public LZ4InputStream(InputStream stream) {
        super(stream);
    }

    public LZ4InputStream(InputStream stream, ReadableByteChannel channel) {
        super(stream, channel);
    }

    @Override
    public void decompress(ByteBuffer compressed, int compressedOffset, int compressedSize, ByteBuffer uncompressed,
            int uncompressedOffset, int uncompressedSize) {
        LZ4.decompressBuffer(compressed, compressedOffset, compressedSize, uncompressed, uncompressedOffset, uncompressedSize);
    }

}
