package org.simantics.logback.configuration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;

public class WorkspaceAppender<E> extends RollingFileAppender<E> {

	String waitingFile = null;
	RollingPolicy waitingRollingPolicy;
	TriggeringPolicy<E> waitingTriggeringPolicy;
	List<E> waitingEvent = new ArrayList<>();
	boolean waitingStart = false;
	
	@Override
	public void setFile(String file) {
		if (file != null) {
			URL url = Platform.getInstanceLocation().getURL();
			File f = new File (file);
			if (!(f.getAbsolutePath().equals(file))) {
				if (url != null) {
					String urls = url.toString();
					if (urls.startsWith("file:/")) {
						urls = urls.substring(6);
						file = urls+file;
					}
				} else {
					// Log may be initialized before user has selected workspace. 
					waitingFile = file;
					// We use a thread to poll workspace location. (An attemp to use a ServiceTracker failed).
					Thread t = new Thread("Simantics Logback redirect") {
						public void run() {
							while (true) {
								URL url = Platform.getInstanceLocation().getURL();
								if (url != null) {
									redirectLog(Platform.getInstanceLocation());
									break;
								}
								try {
									Thread.sleep(100);
								} catch (InterruptedException e) {
									
								}
							}
						};
					};
					t.start();
					return;
				}
			}
		}
		super.setFile(file);
	}
	
	private void redirectLog(Location location) {
		if (waitingFile == null)
			return;
		URL url = Platform.getInstanceLocation().getURL();
		if (url == null)
			return;
		String urls = url.toString();
		if (urls.startsWith("file:/")) {
			urls = urls.substring(6);
			String file = urls+waitingFile;
			synchronized (this) {
				super.setFile(file);
				if (waitingRollingPolicy != null)
					super.setRollingPolicy(waitingRollingPolicy);
				if (waitingTriggeringPolicy != null)
					super.setTriggeringPolicy(waitingTriggeringPolicy);
			
				waitingFile = null;
				waitingRollingPolicy = null;
				waitingTriggeringPolicy = null;
				if (waitingStart) {
					waitingStart = false;
					super.start();
					for (E e : waitingEvent) {
						append(e);
					}
					waitingEvent.clear();
				} else {
					// Start should be called before any log events, and the
					// default implementation ignores log events before start.
					waitingEvent.clear();
				}
			}
			
		}
	}
	
	@Override
	public void start() {
		if (waitingFile != null) {
			waitingStart = true;
			return;
		}
		super.start();
	}
	
	
	
	@Override
	protected void append(E eventObject) {
		synchronized (this) {
			// We must collect log events before log has been started.
			if (waitingFile != null) {
				waitingEvent.add(eventObject);
				return;
			}
		}
		super.append(eventObject);
	}
	
	
	@Override
	public void setRollingPolicy(RollingPolicy policy) {
		if (waitingFile != null) {
			waitingRollingPolicy = policy;
			return;
		}
		super.setRollingPolicy(policy);
	}
	
	@Override
	public void setTriggeringPolicy(TriggeringPolicy<E> policy) {
		if (waitingFile != null) {
			waitingTriggeringPolicy = policy;
			return;
		}
		super.setTriggeringPolicy(policy);
	}
}
