/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.direct;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public final class GraphUtils {
    public static Resource createScalarString(WriteGraph graph, String string) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.String);
        graph.claimValue(ret, (Object)string);
        return ret;
    }

    public static Resource createScalarInteger(WriteGraph graph, int value) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.Integer);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarLong(WriteGraph graph, long value) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.Long);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarFloat(WriteGraph graph, float value) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.Float);
        graph.claimValue(ret, (Object)Float.valueOf(value));
        return ret;
    }

    public static Resource createScalarBoolean(WriteGraph graph, boolean value) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.Boolean);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static Resource createScalarDouble(WriteGraph graph, double value) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        Resource ret = graph.newResource();
        graph.claim(ret, b.InstanceOf, null, b.Double);
        graph.claimValue(ret, (Object)value);
        return ret;
    }

    public static void addRelatedScalarString(WriteGraph graph, Resource resource, Resource relation, String string) throws DatabaseException {
        graph.claim(resource, relation, GraphUtils.createScalarString(graph, string));
    }

    public static void addRelatedScalarInteger(WriteGraph graph, Resource resource, Resource relation, int value) throws DatabaseException {
        graph.claim(resource, relation, GraphUtils.createScalarInteger(graph, value));
    }

    public static Resource createDoubleArray(WriteGraph graph, double[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createDoubleArray(WriteGraph graph, double[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createDoubleArray(graph, array, b.DoubleArray);
    }

    public static Resource createIntegerArray(WriteGraph graph, int[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createIntegerArray(WriteGraph graph, int[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createIntegerArray(graph, array, b.IntegerArray);
    }

    public static Resource createLongArray(WriteGraph graph, long[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createLongArray(WriteGraph graph, long[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createLongArray(graph, array, b.LongArray);
    }

    public static Resource createFloatArray(WriteGraph graph, float[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createFloatArray(WriteGraph graph, float[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createFloatArray(graph, array, b.FloatArray);
    }

    public static Resource createBooleanArray(WriteGraph graph, boolean[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createBooleanArray(WriteGraph graph, boolean[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createBooleanArray(graph, array, b.BooleanArray);
    }

    public static Resource createStringArray(WriteGraph graph, String[] array, Resource type) throws DatabaseException {
        Resource ret = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(ret, b.InstanceOf, null, type);
        graph.claimValue(ret, (Object)array);
        return ret;
    }

    public static Resource createStringArray(WriteGraph graph, String[] array) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        return GraphUtils.createStringArray(graph, array, b.StringArray);
    }

    public static void findResources(ReadGraph graph, Collection<Resource> roots, Resource relation, ResourceTester tester, MultiProcedure<Resource> procedure) throws DatabaseException {
        HashSet<Resource> visited = new HashSet<Resource>();
        Stack<Resource> process = new Stack<Resource>();
        process.addAll(roots);
        visited.addAll(roots);
        while (!process.isEmpty()) {
            Resource cur = (Resource)process.pop();
            for (Resource r : graph.getObjects(cur, relation)) {
                if (visited.contains(r)) continue;
                visited.add(r);
                if (tester.test(graph, r)) {
                    procedure.execute((Object)r);
                }
                process.add(r);
            }
        }
        procedure.finished();
    }

    public static void findResources(ReadGraph graph, Collection<Resource> roots, Resource relation, ResourceTester tester, SyncMultiProcedure<Resource> procedure) throws DatabaseException {
        HashSet<Resource> visited = new HashSet<Resource>();
        Stack<Resource> process = new Stack<Resource>();
        process.addAll(roots);
        visited.addAll(roots);
        while (!process.isEmpty()) {
            Resource cur = (Resource)process.pop();
            for (Resource r : graph.getObjects(cur, relation)) {
                if (visited.contains(r)) continue;
                visited.add(r);
                if (tester.test(graph, r)) {
                    procedure.execute(graph, (Object)r);
                }
                process.add(r);
            }
        }
        procedure.finished(graph);
    }

    public static String getReadableName(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
        return NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
    }

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation, Set<String> result) throws DatabaseException {
        return NameUtils.findReservedNames((ReadGraph)g, (String)proposition, (Resource)container, (Resource)consistRelation, result);
    }

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        return NameUtils.findReservedNames((ReadGraph)g, (String)proposition, (Resource)container, (Resource)consistRelation);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container) throws DatabaseException {
        return NameUtils.findFreshName((ReadGraph)g, (String)proposition, (Resource)container);
    }

    public static String findFreshEscapedName(ReadGraph g, String proposition, Resource container) throws DatabaseException {
        return NameUtils.findFreshEscapedName((ReadGraph)g, (String)proposition, (Resource)container);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        return NameUtils.findFreshName((ReadGraph)g, (String)proposition, (Resource)container, (Resource)consistRelation);
    }

    public static String findFreshEscapedName(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        return NameUtils.findFreshEscapedName((ReadGraph)g, (String)proposition, (Resource)container, (Resource)consistRelation);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, String nameFormat) throws DatabaseException {
        return NameUtils.findFreshName((ReadGraph)g, (String)proposition, (Resource)container, (Resource)consistRelation, (String)nameFormat);
    }

    public static String findFreshInstanceName(ReadGraph g, Resource type, Resource container) throws DatabaseException {
        return NameUtils.findFreshInstanceName((ReadGraph)g, (Resource)type, (Resource)container);
    }

    public static String findFreshInstanceName(ReadGraph g, Resource type, Resource container, Resource relation) throws DatabaseException {
        return NameUtils.findFreshInstanceName((ReadGraph)g, (Resource)type, (Resource)container, (Resource)relation);
    }

    public static Resource create(WriteGraph g, Resource ... predicateObjectPairs) throws DatabaseException {
        assert (predicateObjectPairs.length % 2 == 0);
        Resource resource = g.newResource();
        int i = 0;
        while (i < predicateObjectPairs.length) {
            g.claim(resource, predicateObjectPairs[i], predicateObjectPairs[i + 1]);
            i += 2;
        }
        return resource;
    }

    private static Resource getObjectOrCreatePrimitiveValue(WriteGraph g, Object object) throws DatabaseException {
        if (object == null) {
            throw new NullPointerException("null object");
        }
        Class<?> clazz = object.getClass();
        if (object instanceof Resource) {
            return (Resource)object;
        }
        if (String.class.equals(clazz)) {
            return GraphUtils.createScalarString(g, (String)object);
        }
        if (String[].class.equals(clazz)) {
            return GraphUtils.createStringArray(g, (String[])object);
        }
        if (Integer.class.equals(clazz)) {
            return GraphUtils.createScalarInteger(g, (Integer)object);
        }
        if (int[].class.equals(clazz)) {
            return GraphUtils.createIntegerArray(g, (int[])object);
        }
        if (Long.class.equals(clazz)) {
            return GraphUtils.createScalarLong(g, (Long)object);
        }
        if (long[].class.equals(clazz)) {
            return GraphUtils.createLongArray(g, (long[])object);
        }
        if (Float.class.equals(clazz)) {
            return GraphUtils.createScalarFloat(g, ((Float)object).floatValue());
        }
        if (float[].class.equals(clazz)) {
            return GraphUtils.createFloatArray(g, (float[])object);
        }
        if (Double.class.equals(clazz)) {
            return GraphUtils.createScalarDouble(g, (Double)object);
        }
        if (double[].class.equals(clazz)) {
            return GraphUtils.createDoubleArray(g, (double[])object);
        }
        if (Boolean.class.equals(clazz)) {
            return GraphUtils.createScalarBoolean(g, (Boolean)object);
        }
        if (boolean[].class.equals(clazz)) {
            return GraphUtils.createBooleanArray(g, (boolean[])object);
        }
        throw new UnsupportedOperationException("unsupported object type: " + String.valueOf(object));
    }

    public static Resource create(WriteGraph g, Object ... predicateObjectPairs) throws DatabaseException {
        assert (predicateObjectPairs.length % 2 == 0);
        Resource resource = g.newResource();
        int i = 0;
        while (i < predicateObjectPairs.length) {
            Resource predicate = (Resource)predicateObjectPairs[i];
            Object _object = predicateObjectPairs[i + 1];
            Resource object = GraphUtils.getObjectOrCreatePrimitiveValue(g, _object);
            g.claim(resource, predicate, object);
            i += 2;
        }
        return resource;
    }

    public static Resource create2(WriteGraph g, Resource type, Object ... predicateObjectPairs) throws DatabaseException {
        assert (predicateObjectPairs.length % 2 == 0);
        assert (type != null);
        Resource resource = g.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        g.claim(resource, b.InstanceOf, null, type);
        int i = 0;
        while (i < predicateObjectPairs.length) {
            Resource predicate = (Resource)predicateObjectPairs[i];
            Object _object = predicateObjectPairs[i + 1];
            Resource object = GraphUtils.getObjectOrCreatePrimitiveValue(g, _object);
            g.claim(resource, predicate, object);
            i += 2;
        }
        return resource;
    }

    public static String toString(ReadGraph g, Statement stm) throws DatabaseException {
        return NameUtils.toString((ReadGraph)g, (Statement)stm);
    }

    public static Resource getPossibleChild(ReadGraph g, Resource parent, String name) throws DatabaseException {
        return (Resource)((Map)g.syncRequest((Read)new UnescapedChildMapOfResource(parent))).get(name);
    }

    public static class AcceptAll
    implements ResourceTester {
        @Override
        public boolean test(ReadGraph graph, Resource resource) throws DatabaseException {
            return true;
        }
    }

    public static class Inherits
    implements ResourceTester {
        private final Resource superType;

        public Inherits(Resource superType) {
            this.superType = superType;
        }

        @Override
        public boolean test(ReadGraph graph, Resource resource) throws DatabaseException {
            return graph.isInheritedFrom(resource, this.superType);
        }
    }

    public static class InstanceOf
    implements ResourceTester {
        private final Resource type;

        public InstanceOf(Resource type) {
            this.type = type;
        }

        @Override
        public boolean test(ReadGraph graph, Resource resource) throws DatabaseException {
            return graph.isInstanceOf(resource, this.type);
        }
    }

    public static interface ResourceTester {
        public boolean test(ReadGraph var1, Resource var2) throws DatabaseException;
    }
}

