/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.utils.datastructures.Pair;

public class Relation
extends BinaryPredicate {
    Resource relation;

    public Relation(Resource relation) {
        this.relation = relation;
    }

    @Override
    public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
        return g.getObjects(subject, this.relation);
    }

    @Override
    public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        return g.getObjects(object, g.getInverse(this.relation));
    }

    @Override
    public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
        return g.hasStatement(subject, this.relation, object);
    }

    @Override
    public boolean supportsGetObjects() {
        return true;
    }

    @Override
    public boolean supportsGetStatements() {
        return false;
    }

    @Override
    public boolean supportsGetSubjects() {
        return true;
    }

    @Override
    public void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
        g.claim(subject, this.relation, object);
    }

    @Override
    public void remove(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
        g.denyStatement(subject, this.relation, object);
    }

    @Override
    public boolean supportsAdditions() {
        return true;
    }

    @Override
    public boolean supportsRemovals() {
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Relation other = (Relation)obj;
        return !(this.relation == null ? other.relation != null : !this.relation.equals(other.relation));
    }

    @Override
    public IBinaryPredicate inverse(ReadGraph g) throws DatabaseException {
        return new Relation(g.getInverse(this.relation));
    }

    @Override
    public String toString(ReadGraph g) throws DatabaseException {
        return NameUtils.getSafeName((ReadGraph)g, (Resource)this.relation);
    }
}

