/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.layer0.utils.predicates;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class Type extends UnaryPredicate {

	Resource type;

	public Type(Resource type) {
		this.type = type;
	}
	
	public Resource getType() {
        return type;
    }

	@Override
	public Collection<Resource> getResources(ReadGraph g) {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean has(ReadGraph g, Resource resource) throws DatabaseException {
		return g.isInstanceOf(resource, type);
	}

	@Override
	public boolean supportsUnboundedQuery() {
		return false;
	}

	@Override
	public void add(WriteGraph g, Resource r) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
		if(!g.isInstanceOf(r, type))
			g.claim(r, b.InstanceOf, null, type);
	}

	@Override
	public void remove(WriteGraph g, Resource r) throws DatabaseException {
		// FIXME not implemented correctly
    	Layer0 b = Layer0.getInstance(g);
		if(g.isInstanceOf(r, type))
			g.denyStatement(r, b.InstanceOf, type);
	}

	@Override
	public boolean supportsAddition() {
		return true;
	}

	@Override
	public boolean supportsRemoval() {
		return false;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Type other = (Type) obj;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		return true;
	}
	
}
