/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.xyline;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.ColorPicker;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.jfreechart.chart.properties.RVIFactory;
import org.simantics.jfreechart.chart.properties.RVIModifier;
import org.simantics.jfreechart.chart.properties.RangeComposite;
import org.simantics.jfreechart.chart.properties.TrackedSpinner;
import org.simantics.jfreechart.chart.properties.VariableExistsValidator;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class SeriesPropertyComposite
extends Composite {
    public SeriesPropertyComposite(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        super(parent, style);
        this.createContent(context, support);
    }

    protected void createContent(ISessionContext context, WidgetSupport support) {
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo((Composite)this);
        this.variable(this, context, support);
        this.range(this, context, support);
        this.seriesLabel(this, context, support);
        this.color(this, context, support);
        this.lineWidth(this, support);
    }

    protected TrackedText variable(Composite container, ISessionContext context, WidgetSupport support) {
        Label label = new Label(container, 0);
        label.setText("Variable:");
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        TrackedText variable = new TrackedText(container, support, 2048);
        variable.setTextFactory((ReadFactory)new RVIFactory());
        variable.addModifyListener((TextModifyListener)new RVIModifier((Control)variable.getWidget(), support));
        variable.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(variable.getResourceManager()));
        variable.setInputValidator((IInputValidator)new VariableExistsValidator(support, variable));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)variable.getWidget());
        return variable;
    }

    protected RangeComposite range(Composite container, ISessionContext context, WidgetSupport support) {
        Label label = new Label(container, 0);
        label.setText("Range:");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
        RangeComposite rangeComposite = new RangeComposite(container, context, support, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)rangeComposite);
        return rangeComposite;
    }

    protected TrackedText seriesLabel(Composite container, ISessionContext context, WidgetSupport support) {
        Label label = new Label(container, 0);
        label.setText("Label:");
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        TrackedText labelText = new TrackedText(container, support, 2048);
        labelText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel", ""));
        labelText.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        labelText.setColorProvider((ITrackedColorProvider)new JFreeChartPropertyColorProvider(labelText.getResourceManager()));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)labelText.getWidget());
        return labelText;
    }

    protected ColorPicker color(Composite container, ISessionContext context, WidgetSupport support) {
        Label label = new Label(container, 0);
        label.setText("Color:");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
        ColorPicker colorPicker = new ColorPicker(container, context, support, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)colorPicker);
        return colorPicker;
    }

    protected TrackedSpinner lineWidth(Composite container, WidgetSupport support) {
        Label label = new Label(container, 0);
        label.setText("Line width:");
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        TrackedSpinner width = new TrackedSpinner(container, support, 2048);
        width.setSelectionFactory((ReadFactory<?, Integer>)new WidthSelectionFactory());
        width.addModifyListener(new WidthModifyListener());
        width.setMinimum(1);
        width.setMaximum(10);
        return width;
    }

    private class WidthModifyListener
    implements TextModifyListener,
    Widget {
        private ISessionContext context;
        private Object lastInput = null;

        private WidthModifyListener() {
        }

        public void modifyText(TrackedModifyEvent e) {
            if (this.context == null) {
                return;
            }
            Spinner spinner = (Spinner)e.getWidget();
            final String textValue = spinner.getText();
            final Object input = this.lastInput;
            try {
                this.context.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource series = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        try {
                            Integer value = Integer.parseInt(textValue);
                            graph.claimLiteral(series, jfree.Series_lineWidth, (Object)value, (Binding)Bindings.INTEGER);
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void setInput(ISessionContext context, Object parameter) {
            this.context = context;
            this.lastInput = parameter;
        }
    }

    private class WidthSelectionFactory
    extends ReadFactoryImpl<Resource, Integer> {
        private WidthSelectionFactory() {
        }

        public Integer perform(ReadGraph graph, Resource axis) throws DatabaseException {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Integer width = (Integer)graph.getPossibleRelatedValue(axis, jfree.Series_lineWidth);
            if (width == null) {
                width = 1;
            }
            return width;
        }
    }
}

