/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.swt.widgets.DefaultColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.jfreechart.chart.properties.StringChooserModifyEvent;
import org.simantics.jfreechart.chart.properties.StringChooserModifyListener;

public class StringChooser<T>
implements Widget {
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private int state = 0;
    private Map<T, String> objectToLabel;
    private Set<String> allowedLabels;
    private T selected;
    private final Display display;
    private final Text text;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private ReadFactory<?, T> objectFactory;
    private ITrackedColorProvider colorProvider;
    private final ResourceManager resourceManager;
    private boolean moveCaretAfterEdit = true;
    private boolean selectAllOnStartEdit = true;

    public StringChooser(Composite parent, WidgetSupport support, int style) {
        this.text = new Text(parent, style);
        this.display = this.text.getDisplay();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.text);
        this.colorProvider = new DefaultColorProvider(this.resourceManager);
        if (support != null) {
            support.register((Widget)this);
        }
        this.initialize();
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setFont(Font font) {
        this.text.setFont(font);
    }

    public void setObjectFactory(ReadFactory<?, T> objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setMoveCaretAfterEdit(boolean value) {
        this.moveCaretAfterEdit = value;
    }

    public void setData(Map<T, String> data) {
        this.objectToLabel = data;
        this.allowedLabels = new HashSet<String>();
        this.allowedLabels.addAll(this.objectToLabel.values());
    }

    public void setData(Collection<T> data) {
        this.objectToLabel = new HashMap<T, String>();
        this.allowedLabels = new HashSet<String>();
        for (T t : data) {
            String label = t.toString();
            this.objectToLabel.put(t, label);
            this.allowedLabels.add(label);
        }
    }

    public void setSelected(T selected) {
        if (selected != null) {
            String label = this.objectToLabel.get(selected);
            if (label == null) {
                return;
            }
            this.selected = selected;
            this.text.setText(label);
        } else {
            this.selected = null;
            this.text.setText("");
        }
    }

    public void setSelected(String label) {
        for (T t : this.objectToLabel.keySet()) {
            if (!label.equals(this.objectToLabel.get(t))) continue;
            this.setSelected(t);
            return;
        }
    }

    public void setInput(ISessionContext context, Object input) {
        if (this.modifyListeners != null) {
            Object[] objectArray = this.modifyListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Widget) {
                    ((Widget)o).setInput(context, input);
                }
                ++n2;
            }
        }
        if (this.objectFactory != null) {
            this.objectFactory.listen(context, input, new Listener<T>(){

                public void exception(final Throwable t) {
                    StringChooser.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            (this).StringChooser.this.text.setText(t.toString());
                        }
                    });
                }

                public void execute(final T object) {
                    if (StringChooser.this.text.isDisposed()) {
                        return;
                    }
                    StringChooser.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            StringChooser.this.setSelected(object);
                        }
                    });
                }

                public boolean isDisposed() {
                    return StringChooser.this.text.isDisposed();
                }
            });
        }
    }

    private void initialize() {
        Assert.isNotNull((Object)this.text);
        this.text.setBackground(this.colorProvider.getInactiveBackground());
        this.text.setDoubleClickEnabled(false);
        this.listener = new CompositeListener();
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addDisposeListener((DisposeListener)this.listener);
        this.text.addKeyListener((KeyListener)this.listener);
        this.text.addMouseTrackListener((MouseTrackListener)this.listener);
        this.text.addMouseListener((MouseListener)this.listener);
        this.text.addFocusListener((FocusListener)this.listener);
    }

    public void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        this.caretPositionBeforeEdit = this.text.getCaretPosition();
        this.textBeforeEdit = this.text.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.text.selectAll();
        }
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            try {
                if (this.isTextValid() != null) {
                    this.text.setText(this.textBeforeEdit);
                } else if (this.isModified() && !this.text.getText().equals(this.textBeforeEdit)) {
                    this.setSelected(this.text.getText());
                    if (this.modifyListeners != null) {
                        StringChooserModifyEvent<T> event = new StringChooserModifyEvent<T>((org.eclipse.swt.widgets.Widget)this.text, this.selected, this.text.getText());
                        Object[] objectArray = this.modifyListeners.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            ((StringChooserModifyListener)o).modifySelection(event);
                            ++n2;
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.endEdit();
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        if (this.text.isDisposed()) {
            return;
        }
        this.isEditing();
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        if (this.moveCaretAfterEdit) {
            this.text.setSelection(this.text.getCharCount());
        }
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.text.setText(this.textBeforeEdit);
        this.text.setSelection(this.caretPositionBeforeEdit);
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    private boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setSelectAllOnStartEdit(boolean selectAll) {
        this.selectAllOnStartEdit = selectAll;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.text.setEditable(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.text.setEditable(false);
            this.text.setBackground(null);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    public Text getWidget() {
        return this.text;
    }

    public synchronized void addModifyListener(StringChooserModifyListener<T> listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add(listener);
    }

    public synchronized void removeModifyListener(StringChooserModifyListener<T> listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove(listener);
    }

    private String isTextValid() {
        if (this.allowedLabels.contains(this.getWidget().getText())) {
            return null;
        }
        return "There is no such object.";
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    private void setBackground(Color background) {
        if (this.text.isDisposed()) {
            return;
        }
        if (!this.text.getEditable()) {
            return;
        }
        this.text.setBackground(background);
    }

    public boolean isDisposed() {
        return this.text.isDisposed();
    }

    public Display getDisplay() {
        return this.display;
    }

    public String getText() {
        return this.text.getText();
    }

    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    public void dispose() {
        this.allowedLabels.clear();
        this.allowedLabels = null;
        this.objectFactory = null;
        this.objectToLabel.clear();
        this.objectToLabel = null;
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            StringChooser.this.setModified(true);
            String valid = StringChooser.this.isTextValid();
            if (valid != null) {
                StringChooser.this.setBackground(StringChooser.this.colorProvider.getInvalidBackground());
            } else if (StringChooser.this.isEditing()) {
                StringChooser.this.setBackground(StringChooser.this.colorProvider.getEditingBackground());
            } else {
                StringChooser.this.setBackground(StringChooser.this.colorProvider.getInactiveBackground());
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            StringChooser.this.getWidget().removeModifyListener((ModifyListener)this);
        }

        private boolean isMultiLine() {
            return (StringChooser.this.text.getStyle() & 2) != 0;
        }

        private boolean hasMultiLineCommitModifier(KeyEvent e) {
            return (e.stateMask & 0x40000) != 0;
        }

        public void keyPressed(KeyEvent e) {
            if (!StringChooser.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 0x100000B || e.keyCode == 13 || e.keyCode == 0x1000050) {
                        StringChooser.this.startEdit(StringChooser.this.selectAllOnStartEdit);
                    } else if (e.character != '\u0000') {
                        StringChooser.this.startEdit(false);
                    }
                } else if (e.keyCode == 0x100000B) {
                    StringChooser.this.startEdit(StringChooser.this.selectAllOnStartEdit);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (this.hasMultiLineCommitModifier(e)) {
                        e.doit = false;
                    } else {
                        StringChooser.this.startEdit(false);
                    }
                } else if (e.keyCode == 9) {
                    StringChooser.this.text.traverse((e.stateMask & 0x20000) != 0 ? 8 : 16);
                    e.doit = false;
                } else if (e.character != '\u0000') {
                    StringChooser.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    StringChooser.this.revertEdit();
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        StringChooser.this.applyEdit();
                    }
                } else if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.hasMultiLineCommitModifier(e)) {
                    StringChooser.this.applyEdit();
                    e.doit = false;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!StringChooser.this.isEditing()) {
                StringChooser.this.setBackground(StringChooser.this.colorProvider.getHoverBackground());
            }
            StringChooser.this.setMouseInsideControl(true);
        }

        public void mouseExit(MouseEvent e) {
            if (!StringChooser.this.isEditing()) {
                StringChooser.this.setBackground(StringChooser.this.colorProvider.getInactiveBackground());
            }
            StringChooser.this.setMouseInsideControl(false);
        }

        public void mouseHover(MouseEvent e) {
            StringChooser.this.setMouseInsideControl(true);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                StringChooser.this.getWidget().selectAll();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!StringChooser.this.isEditing()) {
                if (e.button == 1) {
                    StringChooser.this.startEdit(StringChooser.this.selectAllOnStartEdit);
                }
            } else if (e.button == 1 && (StringChooser.this.state & 4) != 0) {
                if (!this.isMultiLine()) {
                    StringChooser.this.getWidget().selectAll();
                }
                StringChooser.this.state &= 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!StringChooser.this.isEditing() && !this.isMultiLine()) {
                StringChooser.this.startEdit(StringChooser.this.selectAllOnStartEdit);
            }
        }

        public void focusLost(FocusEvent e) {
            if (StringChooser.this.isEditing()) {
                StringChooser.this.applyEdit();
            }
        }
    }
}

