/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Quad;

public class DoublePropertyFactory2
extends ReadFactoryImpl<Resource, String> {
    private final String propertyURI;
    private final String typeURI;
    private final Double defaultValue;

    public DoublePropertyFactory2(String propertyURI) {
        this(null, propertyURI);
    }

    public DoublePropertyFactory2(String typeURI, String propertyURI) {
        this(typeURI, propertyURI, 0.0);
    }

    public DoublePropertyFactory2(String typeURI, String propertyURI, double defaultValue) {
        this.propertyURI = propertyURI;
        this.typeURI = typeURI;
        this.defaultValue = defaultValue;
    }

    public Object getIdentity(Object inputContents) {
        return new Quad((Object)((Resource)inputContents), (Object)this.propertyURI, ((Object)((Object)this)).getClass(), (Object)this.defaultValue);
    }

    public String perform(ReadGraph graph, Resource r) throws DatabaseException {
        if (this.typeURI == null) {
            return this.getValue(graph, r);
        }
        Resource type = graph.getResource(this.typeURI);
        Iterator iterator = ((Collection)graph.syncRequest((Read)new ObjectsWithType(r, Layer0.getInstance((ReadGraph)graph).ConsistsOf, type))).iterator();
        if (iterator.hasNext()) {
            Resource o = (Resource)iterator.next();
            return this.getValue(graph, o);
        }
        return "";
    }

    private String getValue(ReadGraph graph, Resource resource) throws DatabaseException {
        Double value = (Double)graph.getPossibleRelatedValue(resource, graph.getResource(this.propertyURI), (Binding)Bindings.DOUBLE);
        if (value != null) {
            return value.toString();
        }
        if (this.defaultValue != null) {
            return this.defaultValue.toString();
        }
        return "";
    }
}

