/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties.xyline;

import java.util.ArrayList;
import java.util.Map;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;

/**
 * ExplorerComposite allowing ontology-based DnD definitions. DnD Copied from {@link ModelBrowser2}
 * 
 * @author Teemu Lempinen
 *
 */
public class AxisAndVariablesExplorerComposite extends GraphExplorerComposite {

    volatile DndBrowseContext dndBrowseContext;
    
    public AxisAndVariablesExplorerComposite(Map<String, Object> args, IWorkbenchSite site, Composite parent,
            WidgetSupport support, int style) {
        super(args, site, parent, support, style);
        
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException { 
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : getBrowseContexts()) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext != null)
                        browseContexts.add(browseContext);
                }
                try {
                    dndBrowseContext = DndBrowseContext.create(graph, browseContexts);
                } catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError(e);
                }
            }
        });
    }
    
    @Override
    public void handleDrop(final Object data, final NodeContext target) {
        if (target == null)
            return;

        Simantics.getSession().asyncRequest(new Read<Runnable>() {
            @Override
            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (dndBrowseContext == null)
                    return null;
                return dndBrowseContext.getAction(graph, target, data);
            }
        }, new Procedure<Runnable>() {
            @Override
            public void execute(Runnable result) {
                if (result != null)
                    result.run();
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError(t);
            }
        });
    }

}
