package org.simantics.jfreechart.chart.properties;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Variable exists validator for tracked text widgets. 
 * 
 * @author Teemu Lempinen
 *
 */
public class VariableExistsValidator implements IInputValidator, Widget {

	protected Collection<ChartVariable> variables;
    protected TrackedText text;
    private boolean allowEmpty;
    @SuppressWarnings("unused")
    private boolean useLabels = false;
    
    /**
     * Validate against all variables
     * 
     * Do not allow empty input
     * @param support WidgetSupport
     * @param text Text widget
     */
    public VariableExistsValidator(WidgetSupport support, TrackedText text) {
        this(support, text, false);
    }
    
   
    
    /**
     * Validate against all variables
     * 
     * @param support WidgetSupport
     * @param text Text widget
     * @param allowEmpty Allow empty input text
     */
    public VariableExistsValidator(WidgetSupport support, TrackedText text, boolean allowEmpty) {
        support.register(this);
        this.variables = new ArrayList<ChartVariable>();
        this.text = text;
        this.allowEmpty = allowEmpty;
    }
    
    public VariableExistsValidator(WidgetSupport support, TrackedText text, boolean allowEmpty, boolean useLabels) {
        this(support, text, allowEmpty);
        this.useLabels = useLabels;
    }
    
    /**
     * Returns null if there is a variable named newText in the model
     */
    @Override
    public String isValid(String newText) {
        if(newText == null || newText.isEmpty()) {
            if(allowEmpty)
                return null;
            else
                return "Empty name not allowed";
        }
        
        synchronized (variables) {
            for(ChartVariable variable : variables) {
                if(newText.equals(variable.getLabel()))
                    return null;
                if(newText.equals(variable.getRvi()))
                    return null;
            }
        }
        
        return "Not a valid variable name";
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        final Resource resource = AdaptionUtils.adaptToSingle(input, Resource.class);
        
        if(resource == null) {
            variables = new ArrayList<ChartVariable>();
            return;
        }
        
       
        try {
            /* Find the model resource. It can be found with PartOf 
               relations from series resource in a chart */
           AllVariablesOfModel query = AllVariablesOfModel.withRandomResource(context, resource);
            
            if(query != null) {
                // Find all variables and set them as the reference for isValid(String)
                Simantics.getSession().asyncRequest(query
                , new Listener<Collection<ChartVariable>>() {

                    @Override
                    public void execute(Collection<ChartVariable> variables) {
                    	 VariableExistsValidator.this.variables = variables;
                    }

                    @Override
                    public void exception(Throwable t) {
                        t.printStackTrace();
                    }

                    @Override
                    public boolean isDisposed() {
                        return text.isDisposed();
                    }

                }); 
            }
        } catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

}
